/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.importer.diagrams.mermaid;

import com.structurizr.importer.diagrams.AbstractDiagramImporter;
import com.structurizr.importer.diagrams.mermaid.MermaidEncoder;
import com.structurizr.util.StringUtils;
import com.structurizr.view.ImageView;
import com.structurizr.view.View;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;

public class MermaidImporter
extends AbstractDiagramImporter {
    private static final String MERMAID_URL_PROPERTY = "mermaid.url";

    public void importDiagram(ImageView view, File file) throws Exception {
        String content = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        view.setTitle(file.getName());
        this.importDiagram(view, content);
    }

    public void importDiagram(ImageView view, String content) {
        String mermaidServer = this.getViewOrViewSetProperty((View)view, MERMAID_URL_PROPERTY);
        if (StringUtils.isNullOrEmpty((String)mermaidServer)) {
            throw new IllegalArgumentException("Please define a view/viewset property named mermaid.url to specify your Mermaid server");
        }
        String encodedMermaid = new MermaidEncoder().encode(content);
        String url = String.format("%s/img/%s", mermaidServer, encodedMermaid);
        view.setContent(url);
        view.setContentType("image/png");
    }
}

