/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.importer.diagrams.plantuml;

import com.structurizr.importer.diagrams.AbstractDiagramImporter;
import com.structurizr.importer.diagrams.plantuml.PlantUMLEncoder;
import com.structurizr.util.StringUtils;
import com.structurizr.view.ImageView;
import com.structurizr.view.View;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;

public class PlantUMLImporter
extends AbstractDiagramImporter {
    private static final String PLANTUML_URL_PROPERTY = "plantuml.url";
    private static final String TITLE_STRING = "title ";
    private static final String NEWLINE = "\n";

    public void importDiagram(ImageView view, File file) throws Exception {
        String content = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        view.setTitle(file.getName());
        this.importDiagram(view, content);
    }

    public void importDiagram(ImageView view, String content) throws Exception {
        String[] lines;
        String plantUMLServer = this.getViewOrViewSetProperty((View)view, PLANTUML_URL_PROPERTY);
        if (StringUtils.isNullOrEmpty((String)plantUMLServer)) {
            throw new IllegalArgumentException("Please define a view/viewset property named plantuml.url to specify your PlantUML server");
        }
        String encodedPlantUML = new PlantUMLEncoder().encode(content);
        String url = String.format("%s/png/%s", plantUMLServer, encodedPlantUML);
        view.setContent(url);
        view.setContentType("image/png");
        for (String line : lines = content.split(NEWLINE)) {
            if (!line.startsWith(TITLE_STRING)) continue;
            String title = line.substring(TITLE_STRING.length());
            view.setTitle(title);
        }
    }
}

