/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.importer.documentation;

import com.structurizr.documentation.Documentable;
import com.structurizr.documentation.Format;
import com.structurizr.documentation.Section;
import com.structurizr.importer.documentation.DocumentationImportException;
import com.structurizr.importer.documentation.DocumentationImporter;
import com.structurizr.importer.documentation.FormatFinder;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultDocumentationImporter
implements DocumentationImporter {
    @Override
    public void importDocumentation(Documentable documentable, File path) {
        if (documentable == null) {
            throw new IllegalArgumentException("A workspace, software system, or container must be specified.");
        }
        if (path == null) {
            throw new IllegalArgumentException("A path must be specified.");
        }
        if (!path.exists()) {
            throw new IllegalArgumentException(path.getAbsolutePath() + " does not exist.");
        }
        try {
            if (path.isDirectory()) {
                File[] filesInDirectory = path.listFiles();
                if (filesInDirectory != null) {
                    Arrays.sort(filesInDirectory);
                    for (Object object : filesInDirectory) {
                        if (((File)object).isDirectory() || ((File)object).getName().startsWith(".")) continue;
                        this.importFile(documentable, (File)object);
                    }
                }
            } else {
                this.importFile(documentable, path);
            }
            for (Section section : documentable.getDocumentation().getSections()) {
                String filename = section.getFilename();
                if ((filename = filename.replace(path.getCanonicalPath(), "")).startsWith("/")) {
                    filename = filename.substring(1);
                }
                section.setFilename(filename);
            }
        }
        catch (Exception e) {
            throw new DocumentationImportException(e);
        }
    }

    protected void importFile(Documentable documentable, File file) throws Exception {
        if (FormatFinder.isMarkdownOrAsciiDoc(file)) {
            Format format = FormatFinder.findFormat(file);
            String sectionDefinition = "";
            if (format == Format.Markdown) {
                sectionDefinition = "##";
            } else if (format == Format.AsciiDoc) {
                sectionDefinition = "==";
            }
            String content = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
            String sectionName = file.getName();
            Matcher matcher = Pattern.compile("^" + sectionDefinition + " (.*?)$", 8).matcher(content);
            if (matcher.find()) {
                sectionName = matcher.group(1);
            }
            Section section = new Section(sectionName, format, content);
            section.setFilename(file.getCanonicalPath());
            documentable.getDocumentation().addSection(section);
        }
    }
}

