/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.importer.diagrams.mermaid;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public final class MermaidEncoder {
    private static final String TEMPLATE = "{ \"code\":\"%s\", \"mermaid\":{\"theme\":\"default\"}}";

    public String encode(String mermaidDefinition) {
        return this.encode(mermaidDefinition, false);
    }

    public String encode(String mermaidDefinition, boolean compress) {
        if (compress) {
            try {
                String content = String.format(TEMPLATE, mermaidDefinition.replaceAll("\n", "\\\\n").replaceAll("\"", "\\\\\""));
                byte[] compressedDefinition = this.compress(content);
                return "pako:" + Base64.getUrlEncoder().encodeToString(compressedDefinition);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return Base64.getUrlEncoder().encodeToString(mermaidDefinition.getBytes(StandardCharsets.UTF_8));
    }

    private byte[] compress(String content) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Deflater deflater = new Deflater();
        DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)baos, deflater, true);
        dos.write(content.getBytes(StandardCharsets.UTF_8));
        dos.finish();
        return baos.toByteArray();
    }
}

