/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.importer.documentation;

import com.structurizr.documentation.Decision;
import com.structurizr.documentation.Documentable;
import com.structurizr.documentation.Format;
import com.structurizr.importer.documentation.AbstractDecisionImporter;
import com.structurizr.importer.documentation.DocumentationImportException;
import com.structurizr.util.StringUtils;
import java.io.File;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AdrToolsDecisionImporter
extends AbstractDecisionImporter {
    private static final String STATUS_PROPOSED = "Proposed";
    private static final String STATUS_SUPERSEDED = "Superseded";
    private static final String SUPERCEDED_ALTERNATIVE_SPELLING = "Superceded";
    private static final String DATE_PREFIX = "Date: ";
    private static final String STATUS_HEADING = "## Status";
    private static final String CONTEXT_HEADING = "## Context";
    private static final Pattern LINK_REGEX = Pattern.compile("(.*) \\[.*]\\((.*)\\)");
    private String dateFormat = "yyyy-MM-dd";

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    @Override
    public void importDocumentation(Documentable documentable, File path) {
        if (documentable == null) {
            throw new IllegalArgumentException("A workspace, software system, container, or component must be specified.");
        }
        if (path == null) {
            throw new IllegalArgumentException("A path must be specified.");
        }
        if (!path.exists()) {
            throw new IllegalArgumentException(path.getAbsolutePath() + " does not exist.");
        }
        if (!path.isDirectory()) {
            throw new IllegalArgumentException(path.getAbsolutePath() + " is not a directory.");
        }
        try {
            LinkedHashMap<String, Decision> decisionsById = new LinkedHashMap<String, Decision>();
            File[] markdownFiles = path.listFiles((dir, name) -> name.endsWith(".md"));
            if (markdownFiles != null) {
                HashMap<String, Decision> decisionsByFilename = new HashMap<String, Decision>();
                for (File file : markdownFiles) {
                    Decision decision = this.importDecision(file);
                    documentable.getDocumentation().addDecision(decision);
                    decisionsById.put(decision.getId(), decision);
                    decisionsByFilename.put(file.getName(), decision);
                }
                for (Decision decision : decisionsById.values()) {
                    this.extractLinks(decision, decisionsByFilename);
                    String content = decision.getContent();
                    for (String filename : decisionsByFilename.keySet()) {
                        content = content.replace(filename, this.calculateUrl((Decision)decisionsByFilename.get(filename)));
                    }
                    decision.setContent(content);
                }
            }
        }
        catch (Exception e) {
            throw new DocumentationImportException(e);
        }
    }

    protected Decision importDecision(File file) throws Exception {
        String id = this.extractIntegerIDFromFileName(file);
        Decision decision = new Decision(id);
        String content = Files.readString(file.toPath(), this.characterEncoding);
        content = content.replace("\r", "");
        decision.setContent(content);
        String[] lines = content.split("\\n");
        decision.setTitle(this.extractTitle(lines));
        decision.setDate(this.extractDate(lines));
        decision.setStatus(this.extractStatus(lines));
        decision.setFormat(Format.Markdown);
        return decision;
    }

    protected String extractIntegerIDFromFileName(File file) {
        return "" + Integer.parseInt(file.getName().substring(0, 4));
    }

    protected String extractTitle(String[] lines) {
        String titleLine = lines[0];
        return titleLine.substring(titleLine.indexOf(".") + 2);
    }

    protected Date extractDate(String[] lines) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormat);
        sdf.setTimeZone(this.timeZone);
        for (String line : lines) {
            if (!line.startsWith(DATE_PREFIX)) continue;
            String dateAsString = line.substring(DATE_PREFIX.length());
            return sdf.parse(dateAsString);
        }
        return new Date();
    }

    protected String extractStatus(String[] lines) {
        boolean inStatusSection = false;
        for (String line : lines) {
            if (!inStatusSection) {
                if (!line.startsWith(STATUS_HEADING)) continue;
                inStatusSection = true;
                continue;
            }
            if (StringUtils.isNullOrEmpty((String)line)) continue;
            String status = line.split(" ")[0];
            if (SUPERCEDED_ALTERNATIVE_SPELLING.equals(status)) {
                status = STATUS_SUPERSEDED;
            }
            return status;
        }
        return STATUS_PROPOSED;
    }

    protected void extractLinks(Decision decision, Map<String, Decision> decisionsByFilename) {
        String[] lines = decision.getContent().split("\\n");
        boolean inStatusSection = false;
        for (String line : lines) {
            Matcher matcher;
            if (!inStatusSection) {
                if (!line.startsWith(STATUS_HEADING)) continue;
                inStatusSection = true;
                continue;
            }
            if (line.startsWith(CONTEXT_HEADING)) {
                return;
            }
            if (StringUtils.isNullOrEmpty((String)line) || !(matcher = LINK_REGEX.matcher(line)).find()) continue;
            String linkDescription = matcher.group(1);
            String target = matcher.group(2);
            Decision targetDecision = decisionsByFilename.get(target);
            if (targetDecision == null) continue;
            decision.addLink(targetDecision, linkDescription);
        }
    }

    protected String calculateUrl(Decision decision) throws Exception {
        return "#" + this.urlEncode(decision.getId());
    }

    protected String urlEncode(String value) throws Exception {
        return URLEncoder.encode(value, StandardCharsets.UTF_8.toString()).replaceAll("\\+", "%20");
    }
}

