/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.importer.documentation;

import com.structurizr.documentation.Decision;
import com.structurizr.documentation.Documentable;
import com.structurizr.documentation.Format;
import com.structurizr.importer.documentation.AbstractDecisionImporter;
import com.structurizr.importer.documentation.DocumentationImportException;
import java.io.File;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Log4brainsDecisionImporter
extends AbstractDecisionImporter {
    private static final String DATE_PREFIX = "- Date: ";
    private static final String STATUS_PREFIX = "- Status: ";
    private static final Pattern STATUS_LINK_REGEX = Pattern.compile("- Status: (.*) \\[.*]\\((.*)\\)");
    private static final String SUPERSEDED = "superseded";
    private static final String LINKS_HEADING = "## Links";
    private static final Pattern LINK_REGEX = Pattern.compile("- (.*) \\[.*]\\((.*)\\)");
    private static final String DATE_FORMAT_IN_FILENAME = "yyyyMMdd";
    private static final String DATE_FORMAT_IN_CONTENT = "yyyy-MM-dd";

    @Override
    public void importDocumentation(Documentable documentable, File path) {
        if (documentable == null) {
            throw new IllegalArgumentException("A workspace, software system, container, or component must be specified.");
        }
        if (path == null) {
            throw new IllegalArgumentException("A path must be specified.");
        }
        if (!path.exists()) {
            throw new IllegalArgumentException(path.getAbsolutePath() + " does not exist.");
        }
        if (!path.isDirectory()) {
            throw new IllegalArgumentException(path.getAbsolutePath() + " is not a directory.");
        }
        try {
            LinkedHashMap<String, Decision> decisionsById = new LinkedHashMap<String, Decision>();
            File[] markdownFiles = path.listFiles((dir, name) -> name.matches("\\d{4}\\d{2}\\d{2}-.+?.md"));
            if (markdownFiles != null) {
                HashMap<String, Decision> decisionsByFilename = new HashMap<String, Decision>();
                Arrays.sort(markdownFiles, Comparator.comparing(File::getName));
                int decisionId = 1;
                for (File file : markdownFiles) {
                    Decision decision = this.importDecision(decisionId, file);
                    documentable.getDocumentation().addDecision(decision);
                    decisionsById.put(decision.getId(), decision);
                    decisionsByFilename.put(file.getName(), decision);
                    ++decisionId;
                }
                for (Decision decision : decisionsById.values()) {
                    this.extractLinks(decision, decisionsByFilename);
                    String content = decision.getContent();
                    for (String filename : decisionsByFilename.keySet()) {
                        content = content.replace(filename, this.calculateUrl((Decision)decisionsByFilename.get(filename)));
                    }
                    decision.setContent(content);
                }
            }
        }
        catch (Exception e) {
            throw new DocumentationImportException(e);
        }
    }

    protected Decision importDecision(int id, File file) throws Exception {
        Decision decision = new Decision("" + id);
        String content = Files.readString(file.toPath(), this.characterEncoding);
        content = content.replace("\r", "");
        decision.setContent(content);
        String[] lines = content.split("\\n");
        decision.setTitle(this.extractTitle(lines));
        decision.setDate(this.extractDateFromFilename(file));
        Date dateFromContent = this.extractDate(lines);
        if (dateFromContent != null) {
            decision.setDate(dateFromContent);
        }
        decision.setStatus(this.extractStatus(lines));
        decision.setFormat(Format.Markdown);
        return decision;
    }

    protected Date extractDateFromFilename(File file) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_IN_FILENAME);
        sdf.setTimeZone(this.timeZone);
        return sdf.parse(file.getName().substring(0, DATE_FORMAT_IN_FILENAME.length()));
    }

    protected String extractTitle(String[] lines) {
        String titleLine = lines[0];
        return titleLine.substring(2);
    }

    protected Date extractDate(String[] lines) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_IN_CONTENT);
        sdf.setTimeZone(this.timeZone);
        for (String line : lines) {
            if (!line.startsWith(DATE_PREFIX)) continue;
            String dateAsString = line.substring(DATE_PREFIX.length());
            return sdf.parse(dateAsString);
        }
        return null;
    }

    protected String extractStatus(String[] lines) {
        for (String line : lines) {
            if (!line.startsWith(STATUS_PREFIX)) continue;
            String status = line.substring(STATUS_PREFIX.length());
            if (status.startsWith(SUPERSEDED)) {
                return SUPERSEDED;
            }
            return status;
        }
        return "";
    }

    protected void extractLinks(Decision decision, Map<String, Decision> decisionsByFilename) {
        String[] lines;
        boolean inLinksSection = false;
        for (String line : lines = decision.getContent().split("\\n")) {
            Decision targetDecision;
            String linkDescription;
            Matcher matcher;
            if (line.startsWith(STATUS_PREFIX) && (matcher = STATUS_LINK_REGEX.matcher(line)).find()) {
                linkDescription = matcher.group(1);
                String markdownFile = matcher.group(2);
                targetDecision = decisionsByFilename.get(markdownFile);
                if (targetDecision != null) {
                    decision.addLink(targetDecision, linkDescription);
                }
            }
            if (line.startsWith(LINKS_HEADING)) {
                inLinksSection = true;
            }
            if (!inLinksSection || !(matcher = LINK_REGEX.matcher(line)).find()) continue;
            linkDescription = matcher.group(1);
            String target = matcher.group(2);
            targetDecision = decisionsByFilename.get(target);
            if (targetDecision == null) continue;
            decision.addLink(targetDecision, linkDescription);
        }
    }

    protected String calculateUrl(Decision decision) throws Exception {
        return "#" + this.urlEncode(decision.getId());
    }

    protected String urlEncode(String value) throws Exception {
        return URLEncoder.encode(value, StandardCharsets.UTF_8.toString()).replaceAll("\\+", "%20");
    }
}

