/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.importer.documentation;

import com.structurizr.documentation.Decision;
import com.structurizr.documentation.Documentable;
import com.structurizr.documentation.Format;
import com.structurizr.importer.documentation.AbstractDecisionImporter;
import com.structurizr.importer.documentation.DocumentationImportException;
import java.io.File;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MadrDecisionImporter
extends AbstractDecisionImporter {
    private static final Log log = LogFactory.getLog(MadrDecisionImporter.class);
    private static final String STATUS_PREFIX = "status: ";
    private static final String DEFAULT_STATUS = "accepted";
    private static final String DATE_PREFIX = "date: ";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final Pattern LINK_REGEX = Pattern.compile("\\[.*]\\((.*)\\)");
    private static final String FRONT_MATTER_SEPARATOR = "---";
    private static final String DEFAULT_LINK_DESCRIPTION = "Links to";

    @Override
    public void importDocumentation(Documentable documentable, File path) {
        if (documentable == null) {
            throw new IllegalArgumentException("A workspace, software system, container, or component must be specified.");
        }
        if (path == null) {
            throw new IllegalArgumentException("A path must be specified.");
        }
        if (!path.exists()) {
            throw new IllegalArgumentException(path.getAbsolutePath() + " does not exist.");
        }
        if (!path.isDirectory()) {
            throw new IllegalArgumentException(path.getAbsolutePath() + " is not a directory.");
        }
        LinkedHashMap<String, Decision> decisionsById = new LinkedHashMap<String, Decision>();
        File[] markdownFiles = path.listFiles((dir, name) -> name.matches("\\d{4}-.+?.md"));
        if (markdownFiles != null) {
            HashMap<String, Decision> decisionsByFilename = new HashMap<String, Decision>();
            Arrays.sort(markdownFiles, Comparator.comparing(File::getName));
            for (File file : markdownFiles) {
                try {
                    Decision decision = this.importDecision(file);
                    documentable.getDocumentation().addDecision(decision);
                    decisionsById.put(decision.getId(), decision);
                    decisionsByFilename.put(file.getName(), decision);
                }
                catch (Exception e) {
                    throw new DocumentationImportException("Error importing decision from + " + file.getAbsolutePath(), e);
                }
            }
            for (Decision decision : decisionsById.values()) {
                try {
                    this.extractLinks(decision, decisionsByFilename);
                    String content = decision.getContent();
                    for (String filename : decisionsByFilename.keySet()) {
                        content = content.replace(filename, this.calculateUrl((Decision)decisionsByFilename.get(filename)));
                    }
                    decision.setContent(content);
                }
                catch (Exception e) {
                    log.warn((Object)("Error extracting links from decision with ID " + decision.getId()));
                }
            }
        }
    }

    protected Decision importDecision(File file) throws Exception {
        String id = this.extractIntegerIDFromFileName(file);
        Decision decision = new Decision(id);
        String content = Files.readString(file.toPath(), this.characterEncoding);
        content = content.replace("\r", "");
        String contentWithoutFrontMatter = content.replaceFirst("(?m)^---\n(^.*\n)*?---\n", "");
        decision.setContent(contentWithoutFrontMatter);
        String[] linesWithFrontMatter = content.split("\\n");
        String[] linesWithoutFrontMatter = contentWithoutFrontMatter.split("\\n");
        decision.setTitle(this.extractTitle(linesWithoutFrontMatter));
        decision.setDate(this.extractDate(file));
        Date dateFromFrontMatter = this.extractDate(linesWithFrontMatter);
        if (dateFromFrontMatter != null) {
            decision.setDate(dateFromFrontMatter);
        }
        decision.setStatus(this.extractStatus(linesWithFrontMatter));
        decision.setFormat(Format.Markdown);
        return decision;
    }

    protected String extractIntegerIDFromFileName(File file) {
        return "" + Integer.parseInt(file.getName().substring(0, 4));
    }

    protected String extractTitle(String[] lines) {
        for (String line : lines) {
            if (!line.startsWith("# ")) continue;
            return line.substring(2);
        }
        return "Title";
    }

    protected Date extractDate(File file) throws Exception {
        return new Date(file.lastModified());
    }

    protected Date extractDate(String[] lines) throws Exception {
        if (lines[0].startsWith(FRONT_MATTER_SEPARATOR)) {
            for (int i = 1; i < lines.length; ++i) {
                String line = lines[i];
                if (line.startsWith(FRONT_MATTER_SEPARATOR)) {
                    return null;
                }
                if (!line.startsWith(DATE_PREFIX)) continue;
                SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
                sdf.setTimeZone(this.timeZone);
                return sdf.parse(line.substring(DATE_PREFIX.length()));
            }
        }
        return null;
    }

    protected String extractStatus(String[] lines) {
        if (lines[0].startsWith(FRONT_MATTER_SEPARATOR)) {
            for (int i = 1; i < lines.length; ++i) {
                String line = lines[i];
                if (line.startsWith(FRONT_MATTER_SEPARATOR)) {
                    return DEFAULT_STATUS;
                }
                if (!line.startsWith(STATUS_PREFIX)) continue;
                return line.substring(STATUS_PREFIX.length());
            }
        }
        return DEFAULT_STATUS;
    }

    protected void extractLinks(Decision decision, Map<String, Decision> decisionsByFilename) {
        String[] lines;
        for (String line : lines = decision.getContent().split("\\n")) {
            Matcher matcher = LINK_REGEX.matcher(line);
            while (matcher.find()) {
                String target = matcher.group(1);
                Decision targetDecision = decisionsByFilename.get(target);
                if (targetDecision == null) continue;
                decision.addLink(targetDecision, DEFAULT_LINK_DESCRIPTION);
            }
        }
    }

    protected String calculateUrl(Decision decision) throws Exception {
        return "#" + this.urlEncode(decision.getId());
    }

    protected String urlEncode(String value) throws Exception {
        return URLEncoder.encode(value, StandardCharsets.UTF_8.toString()).replaceAll("\\+", "%20");
    }
}

