/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.importer.diagrams.image;

import com.structurizr.http.HttpClient;
import com.structurizr.http.RemoteContent;
import com.structurizr.importer.diagrams.AbstractDiagramImporter;
import com.structurizr.util.ImageUtils;
import com.structurizr.view.ColorScheme;
import com.structurizr.view.ImageView;
import com.structurizr.view.View;
import java.io.File;

public class ImageImporter
extends AbstractDiagramImporter {
    public static final String IMAGE_INLINE_PROPERTY = "image.inline";

    public ImageImporter() {
    }

    public ImageImporter(HttpClient httpClient) {
        super(httpClient);
    }

    public void importDiagram(ImageView view, File file) throws Exception {
        this.importDiagram(view, file, null);
    }

    public void importDiagram(ImageView view, File file, ColorScheme colorScheme) throws Exception {
        view.setContent(ImageUtils.getImageAsDataUri((File)file));
        view.setContentType(ImageUtils.getContentType((File)file));
        view.setTitle(file.getName());
    }

    public void importDiagram(ImageView view, String url) throws Exception {
        this.importDiagram(view, url, null);
    }

    public void importDiagram(ImageView view, String url, ColorScheme colorScheme) throws Exception {
        RemoteContent remoteContent = this.httpClient.get(url, false);
        String inline = this.getViewOrViewSetProperty((View)view, IMAGE_INLINE_PROPERTY);
        if ("true".equals(inline)) {
            String contentType = remoteContent.getContentType();
            if (!contentType.equals("image/png") && !contentType.equals("image/svg+xml")) {
                throw new IllegalArgumentException(String.format("Found %s - expected a format of %s or %s", contentType, "png", "svg"));
            }
            if (contentType.equals("image/svg+xml")) {
                view.setContent(ImageUtils.getSvgAsDataUri((String)remoteContent.getContentAsString()), colorScheme);
            } else {
                view.setContent(ImageUtils.getPngAsDataUri((byte[])remoteContent.getContentAsBytes()), colorScheme);
            }
            view.setContentType(contentType);
        } else {
            view.setContent(url, colorScheme);
            view.setContentType(remoteContent.getContentType());
        }
        view.setTitle(url.substring(url.lastIndexOf("/") + 1));
    }
}

