/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.importer.diagrams.mermaid;

import com.structurizr.http.HttpClient;
import com.structurizr.http.RemoteContent;
import com.structurizr.importer.diagrams.AbstractDiagramImporter;
import com.structurizr.importer.diagrams.mermaid.MermaidEncoder;
import com.structurizr.util.ImageUtils;
import com.structurizr.util.StringUtils;
import com.structurizr.view.ColorScheme;
import com.structurizr.view.ImageView;
import com.structurizr.view.View;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;

public class MermaidImporter
extends AbstractDiagramImporter {
    public static final String MERMAID_URL_PROPERTY = "mermaid.url";
    public static final String MERMAID_FORMAT_PROPERTY = "mermaid.format";
    public static final String MERMAID_COMPRESS_PROPERTY = "mermaid.compress";
    public static final String MERMAID_INLINE_PROPERTY = "mermaid.inline";

    public MermaidImporter() {
    }

    public MermaidImporter(HttpClient httpClient) {
        super(httpClient);
    }

    public void importDiagram(ImageView view, File file) throws Exception {
        this.importDiagram(view, file, null);
    }

    public void importDiagram(ImageView view, File file, ColorScheme colorScheme) throws Exception {
        String content = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        view.setTitle(file.getName());
        this.importDiagram(view, content, colorScheme);
    }

    public void importDiagram(ImageView view, String content) throws Exception {
        this.importDiagram(view, content, null);
    }

    public void importDiagram(ImageView view, String content, ColorScheme colorScheme) throws Exception {
        String mermaidServer = this.getViewOrViewSetProperty((View)view, MERMAID_URL_PROPERTY);
        if (StringUtils.isNullOrEmpty((String)mermaidServer)) {
            throw new IllegalArgumentException("Please define a view/viewset property named mermaid.url to specify your Mermaid server");
        }
        String format = this.getViewOrViewSetProperty((View)view, MERMAID_FORMAT_PROPERTY);
        if (StringUtils.isNullOrEmpty((String)format)) {
            format = "svg";
        }
        if (!format.equals("png") && !format.equals("svg")) {
            throw new IllegalArgumentException(String.format("Expected a format of %s or %s", "png", "svg"));
        }
        String compress = this.getViewOrViewSetProperty((View)view, MERMAID_COMPRESS_PROPERTY);
        if (StringUtils.isNullOrEmpty((String)compress)) {
            compress = "true";
        }
        String encodedMermaid = new MermaidEncoder().encode(content, compress.equalsIgnoreCase("true"));
        String url = format.equals("png") ? String.format("%s/img/%s?type=png", mermaidServer, encodedMermaid) : String.format("%s/svg/%s", mermaidServer, encodedMermaid);
        String inline = this.getViewOrViewSetProperty((View)view, MERMAID_INLINE_PROPERTY);
        if ("true".equals(inline)) {
            RemoteContent remoteContent = this.httpClient.get(url, true);
            if (format.equals("svg")) {
                view.setContent(ImageUtils.getSvgAsDataUri((String)remoteContent.getContentAsString()), colorScheme);
            } else {
                view.setContent(ImageUtils.getPngAsDataUri((byte[])remoteContent.getContentAsBytes()), colorScheme);
            }
        } else {
            view.setContent(url, colorScheme);
        }
        view.setContentType((String)CONTENT_TYPES_BY_FORMAT.get(format));
    }
}

