/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.importer.documentation;

import com.structurizr.documentation.Documentable;
import com.structurizr.documentation.Image;
import com.structurizr.importer.documentation.DocumentationImportException;
import com.structurizr.importer.documentation.DocumentationImporter;
import com.structurizr.util.ImageUtils;
import com.structurizr.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Base64;

public class DefaultImageImporter
implements DocumentationImporter {
    @Override
    public void importDocumentation(Documentable documentable, File path) {
        if (documentable == null) {
            throw new IllegalArgumentException("A workspace or software system must be specified.");
        }
        if (path == null) {
            throw new IllegalArgumentException("A path must be specified.");
        }
        if (!path.exists()) {
            throw new IllegalArgumentException(path.getAbsolutePath() + " does not exist.");
        }
        try {
            if (path.isDirectory()) {
                this.importImages(documentable, "", path);
            } else {
                this.importImage(documentable, "", path);
            }
        }
        catch (Exception e) {
            throw new DocumentationImportException(e.getMessage(), e);
        }
    }

    private void importImages(Documentable documentable, String root, File path) throws IOException {
        File[] files = path.listFiles();
        if (files != null) {
            for (File file : files) {
                String name = file.getName().toLowerCase();
                if (file.isDirectory() && !file.isHidden()) {
                    if (StringUtils.isNullOrEmpty((String)root)) {
                        this.importImages(documentable, file.getName(), file);
                        continue;
                    }
                    this.importImages(documentable, root + "/" + file.getName(), file);
                    continue;
                }
                if (!name.endsWith(".png") && !name.endsWith(".jpg") && !name.endsWith(".jpeg") && !name.endsWith(".gif") && !name.endsWith(".svg")) continue;
                this.importImage(documentable, root, file);
            }
        }
    }

    private void importImage(Documentable documentable, String path, File file) throws IOException {
        String base64Content;
        String contentType = ImageUtils.getContentType((File)file);
        Object name = StringUtils.isNullOrEmpty((String)path) ? file.getName() : path + "/" + file.getName();
        if ("image/svg+xml".equalsIgnoreCase(contentType)) {
            base64Content = Base64.getEncoder().encodeToString(Files.readAllBytes(file.toPath()));
        } else {
            contentType = ImageUtils.getContentType((File)file);
            base64Content = ImageUtils.getImageAsBase64((File)file);
        }
        documentable.getDocumentation().addImage(new Image((String)name, contentType, base64Content));
    }
}

