/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.inspection.documentation;

import com.structurizr.Workspace;
import com.structurizr.documentation.Decision;
import com.structurizr.documentation.Documentable;
import com.structurizr.documentation.DocumentationContent;
import com.structurizr.documentation.Format;
import com.structurizr.documentation.Section;
import com.structurizr.inspection.Inspection;
import com.structurizr.inspection.Inspector;
import com.structurizr.inspection.Severity;
import com.structurizr.inspection.Violation;
import com.structurizr.model.Element;
import com.structurizr.model.ModelItem;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractDocumentableInspection
extends Inspection {
    private static final Pattern MARKDOWN_EMBED = Pattern.compile("!\\[.*?]\\(embed:(.+?)\\)");
    private static final Pattern ASCIIDOC_EMBED = Pattern.compile("image::embed:(.+?)\\[]");

    public AbstractDocumentableInspection(Inspector inspector) {
        super(inspector);
    }

    public final Violation run(Documentable documentable) {
        Severity severity;
        if (documentable instanceof Workspace) {
            severity = this.getInspector().getSeverityStrategy().getSeverity((Inspection)this, (Workspace)documentable);
        } else {
            Element element = (Element)documentable;
            severity = this.getInspector().getSeverityStrategy().getSeverity((Inspection)this, element);
        }
        Violation violation = this.inspect(documentable);
        return violation == null ? null : violation.withSeverity(severity);
    }

    protected abstract Violation inspect(Documentable var1);

    protected Set<String> findEmbeddedViewKeys(Documentable documentable) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (Section section : documentable.getDocumentation().getSections()) {
            keys.addAll(this.findEmbeddedViewKeys((DocumentationContent)section));
        }
        for (Decision decision : documentable.getDocumentation().getDecisions()) {
            keys.addAll(this.findEmbeddedViewKeys((DocumentationContent)decision));
        }
        return keys;
    }

    private Set<String> findEmbeddedViewKeys(DocumentationContent content) {
        String[] lines;
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (String line : lines = content.getContent().split("\n")) {
            String key;
            Matcher matcher;
            if (content.getFormat() == Format.Markdown) {
                matcher = MARKDOWN_EMBED.matcher(line);
                if (!matcher.matches()) continue;
                key = matcher.group(1);
                keys.add(key);
                continue;
            }
            if (content.getFormat() != Format.AsciiDoc || !(matcher = ASCIIDOC_EMBED.matcher(line)).matches()) continue;
            key = matcher.group(1);
            keys.add(key);
        }
        return keys;
    }

    protected String terminologyFor(Element element) {
        return this.getWorkspace().getViews().getConfiguration().getTerminology().findTerminology((ModelItem)element).toLowerCase();
    }

    protected String nameOf(Element element) {
        String canonicalName = element.getCanonicalName();
        return canonicalName.substring(canonicalName.indexOf("://") + 3);
    }
}

