/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.inspection.model;

import com.structurizr.inspection.Inspector;
import com.structurizr.inspection.Violation;
import com.structurizr.inspection.model.AbstractElementInspection;
import com.structurizr.model.Element;
import com.structurizr.view.ElementView;
import com.structurizr.view.ModelView;
import com.structurizr.view.View;
import java.util.HashSet;
import java.util.Set;

public class ElementNotIncludedInAnyViewsInspection
extends AbstractElementInspection {
    private final Set<String> elementsInViews = new HashSet<String>();

    public ElementNotIncludedInAnyViewsInspection(Inspector inspector) {
        super(inspector);
        for (View view : this.getWorkspace().getViews().getViews()) {
            if (!(view instanceof ModelView)) continue;
            ModelView modelView = (ModelView)view;
            for (ElementView elementView : modelView.getElements()) {
                this.elementsInViews.add(elementView.getId());
            }
        }
    }

    @Override
    protected Violation inspect(Element element) {
        if (!this.elementsInViews.contains(element.getId())) {
            return this.violation("The " + this.terminologyFor(element) + " named \"" + element.getName() + "\" is not included on any views - add it to a view.");
        }
        return this.noViolation();
    }

    @Override
    protected String getType() {
        return "model.element.noview";
    }
}

