/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.inspection.documentation;

import com.structurizr.Workspace;
import com.structurizr.documentation.Documentable;
import com.structurizr.inspection.Inspector;
import com.structurizr.inspection.Violation;
import com.structurizr.inspection.documentation.AbstractDocumentableInspection;
import com.structurizr.model.Element;
import com.structurizr.view.View;
import java.util.LinkedHashSet;
import java.util.Set;

public class EmbeddedViewMissingInspection
extends AbstractDocumentableInspection {
    public EmbeddedViewMissingInspection(Inspector inspector) {
        super(inspector);
    }

    @Override
    protected Violation inspect(Documentable documentable) {
        Set<String> keys = this.findEmbeddedViewKeys(documentable);
        LinkedHashSet<String> missingViews = new LinkedHashSet<String>();
        for (String key : keys) {
            View view = this.getWorkspace().getViews().getViewWithKey(key);
            if (view != null) continue;
            missingViews.add(key);
        }
        if (!missingViews.isEmpty()) {
            if (documentable instanceof Workspace) {
                return this.violation("The following views are embedded into documentation for the workspace but do not exist in the workspace: " + String.join((CharSequence)", ", missingViews));
            }
            if (documentable instanceof Element) {
                Element element = (Element)documentable;
                return this.violation("The following views are embedded into documentation for the " + this.terminologyFor(element).toLowerCase() + " \"" + this.nameOf(element) + "\" but do not exist in the workspace: " + String.join((CharSequence)", ", missingViews));
            }
        }
        return this.noViolation();
    }

    @Override
    protected String getType() {
        return "documentation.embeddedview";
    }
}

