/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.inspection.model;

import com.structurizr.inspection.Inspector;
import com.structurizr.inspection.Violation;
import com.structurizr.inspection.model.AbstractRelationshipInspection;
import com.structurizr.model.Element;
import com.structurizr.model.Relationship;
import com.structurizr.util.StringUtils;

public class RelationshipTechnologyInspection
extends AbstractRelationshipInspection {
    public RelationshipTechnologyInspection(Inspector inspector) {
        super(inspector);
    }

    @Override
    protected Violation inspect(Relationship relationship) {
        Element source = relationship.getSource();
        Element destination = relationship.getDestination();
        if (StringUtils.isNullOrEmpty((String)relationship.getTechnology())) {
            return this.violation("The relationship between the " + this.terminologyFor(source) + " \"" + this.nameOf(source) + "\" and the " + this.terminologyFor(destination) + " \"" + this.nameOf(destination) + "\" is missing a technology.");
        }
        return this.noViolation();
    }

    @Override
    protected String getType() {
        return "model.relationship.technology";
    }
}

