/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.inspection.view;

import com.structurizr.Workspace;
import com.structurizr.inspection.Inspector;
import com.structurizr.inspection.Violation;
import com.structurizr.inspection.view.AbstractViewsInspection;
import com.structurizr.view.ContainerView;
import java.util.HashSet;

public class ContainerViewsForMultipleSoftwareSystemsInspection
extends AbstractViewsInspection {
    public ContainerViewsForMultipleSoftwareSystemsInspection(Inspector inspector) {
        super(inspector);
    }

    @Override
    protected Violation inspect(Workspace workspace) {
        HashSet<String> softwareSystemsWithContainerViews = new HashSet<String>();
        for (ContainerView view : workspace.getViews().getContainerViews()) {
            softwareSystemsWithContainerViews.add(view.getSoftwareSystemId());
        }
        if (softwareSystemsWithContainerViews.size() > 1) {
            return this.violation("Container views exist for " + softwareSystemsWithContainerViews.size() + " software systems. It is recommended that a workspace includes container views for a single software system only.");
        }
        return this.noViolation();
    }

    @Override
    protected String getType() {
        return "workspace.scope";
    }
}

