/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.inspection;

import com.structurizr.Workspace;
import com.structurizr.documentation.Documentable;
import com.structurizr.inspection.Inspector;
import com.structurizr.inspection.PropertyBasedSeverityStrategy;
import com.structurizr.inspection.SeverityStrategy;
import com.structurizr.inspection.documentation.EmbeddedViewMissingInspection;
import com.structurizr.inspection.documentation.EmbeddedViewWithGeneratedKeyInspection;
import com.structurizr.inspection.model.ComponentDescriptionInspection;
import com.structurizr.inspection.model.ComponentTechnologyInspection;
import com.structurizr.inspection.model.ContainerDescriptionInspection;
import com.structurizr.inspection.model.ContainerTechnologyInspection;
import com.structurizr.inspection.model.DeploymentNodeDescriptionInspection;
import com.structurizr.inspection.model.DeploymentNodeTechnologyInspection;
import com.structurizr.inspection.model.DisconnectedElementInspection;
import com.structurizr.inspection.model.ElementNotIncludedInAnyViewsInspection;
import com.structurizr.inspection.model.EmptyDeploymentNodeInspection;
import com.structurizr.inspection.model.EmptyModelInspection;
import com.structurizr.inspection.model.InfrastructureNodeDescriptionInspection;
import com.structurizr.inspection.model.InfrastructureNodeTechnologyInspection;
import com.structurizr.inspection.model.MultipleSoftwareSystemsDetailedInspection;
import com.structurizr.inspection.model.PersonDescriptionInspection;
import com.structurizr.inspection.model.RelationshipDescriptionInspection;
import com.structurizr.inspection.model.RelationshipTechnologyInspection;
import com.structurizr.inspection.model.SoftwareSystemDecisionsInspection;
import com.structurizr.inspection.model.SoftwareSystemDescriptionInspection;
import com.structurizr.inspection.model.SoftwareSystemDocumentationInspection;
import com.structurizr.inspection.view.ContainerViewsForMultipleSoftwareSystemsInspection;
import com.structurizr.inspection.view.ElementStyleMetadataInspection;
import com.structurizr.inspection.view.EmptyViewInspection;
import com.structurizr.inspection.view.EmptyViewsInspection;
import com.structurizr.inspection.view.GeneratedKeyInspection;
import com.structurizr.inspection.view.ManualLayoutInspection;
import com.structurizr.inspection.view.SystemContextViewsForMultipleSoftwareSystemsInspection;
import com.structurizr.inspection.workspace.WorkspaceScopeInspection;
import com.structurizr.inspection.workspace.WorkspaceToolingInspection;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.Person;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.view.CustomView;
import com.structurizr.view.ElementStyle;
import com.structurizr.view.ModelView;
import com.structurizr.view.View;

public class DefaultInspector
extends Inspector {
    public DefaultInspector(Workspace workspace) {
        super(workspace);
        this.runWorkspaceInspections();
        this.runModelInspections();
        this.runViewInspections();
    }

    private void runWorkspaceInspections() {
        this.add(new WorkspaceToolingInspection(this).run());
        this.add(new WorkspaceScopeInspection(this).run());
        this.add(new EmbeddedViewMissingInspection(this).run((Documentable)this.getWorkspace()));
        this.add(new EmbeddedViewWithGeneratedKeyInspection(this).run((Documentable)this.getWorkspace()));
    }

    private void runModelInspections() {
        this.add(new EmptyModelInspection(this).run());
        this.add(new MultipleSoftwareSystemsDetailedInspection(this).run());
        ElementNotIncludedInAnyViewsInspection elementNotIncludedInAnyViewsCheck = new ElementNotIncludedInAnyViewsInspection(this);
        DisconnectedElementInspection disconnectedElementCheck = new DisconnectedElementInspection(this);
        for (Element element : this.getWorkspace().getModel().getElements()) {
            if (element instanceof Person) {
                this.add(new PersonDescriptionInspection(this).run(element));
            }
            if (element instanceof SoftwareSystem) {
                this.add(new SoftwareSystemDescriptionInspection(this).run(element));
                this.add(new SoftwareSystemDocumentationInspection(this).run(element));
                this.add(new SoftwareSystemDecisionsInspection(this).run(element));
                this.add(new EmbeddedViewMissingInspection(this).run((Documentable)((SoftwareSystem)element)));
                this.add(new EmbeddedViewWithGeneratedKeyInspection(this).run((Documentable)((SoftwareSystem)element)));
            }
            if (element instanceof Container) {
                this.add(new ContainerDescriptionInspection(this).run(element));
                this.add(new ContainerTechnologyInspection(this).run(element));
                this.add(new EmbeddedViewMissingInspection(this).run((Documentable)((Container)element)));
                this.add(new EmbeddedViewWithGeneratedKeyInspection(this).run((Documentable)((Container)element)));
            }
            if (element instanceof Component) {
                this.add(new ComponentDescriptionInspection(this).run(element));
                this.add(new ComponentTechnologyInspection(this).run(element));
                this.add(new EmbeddedViewMissingInspection(this).run((Documentable)((Component)element)));
                this.add(new EmbeddedViewWithGeneratedKeyInspection(this).run((Documentable)((Component)element)));
            }
            if (element instanceof DeploymentNode) {
                this.add(new DeploymentNodeDescriptionInspection(this).run(element));
                this.add(new DeploymentNodeTechnologyInspection(this).run(element));
                this.add(new EmptyDeploymentNodeInspection(this).run(element));
            }
            if (element instanceof InfrastructureNode) {
                this.add(new InfrastructureNodeDescriptionInspection(this).run(element));
                this.add(new InfrastructureNodeTechnologyInspection(this).run(element));
            }
            this.add(disconnectedElementCheck.run(element));
            this.add(elementNotIncludedInAnyViewsCheck.run(element));
            for (Relationship relationship : element.getRelationships()) {
                this.add(new RelationshipDescriptionInspection(this).run(relationship));
                this.add(new RelationshipTechnologyInspection(this).run(relationship));
            }
        }
    }

    private void runViewInspections() {
        this.add(new EmptyViewsInspection(this).run());
        for (CustomView view : this.getWorkspace().getViews().getCustomViews()) {
            this.add(new GeneratedKeyInspection(this).run((View)view));
            this.add(new EmptyViewInspection(this).run((ModelView)view));
            this.add(new ManualLayoutInspection(this).run((ModelView)view));
        }
        for (CustomView view : this.getWorkspace().getViews().getSystemLandscapeViews()) {
            this.add(new GeneratedKeyInspection(this).run((View)view));
            this.add(new EmptyViewInspection(this).run((ModelView)view));
            this.add(new ManualLayoutInspection(this).run((ModelView)view));
        }
        this.add(new SystemContextViewsForMultipleSoftwareSystemsInspection(this).run());
        for (CustomView view : this.getWorkspace().getViews().getSystemContextViews()) {
            this.add(new GeneratedKeyInspection(this).run((View)view));
            this.add(new EmptyViewInspection(this).run((ModelView)view));
            this.add(new ManualLayoutInspection(this).run((ModelView)view));
        }
        this.add(new ContainerViewsForMultipleSoftwareSystemsInspection(this).run());
        for (CustomView view : this.getWorkspace().getViews().getContainerViews()) {
            this.add(new GeneratedKeyInspection(this).run((View)view));
            this.add(new EmptyViewInspection(this).run((ModelView)view));
            this.add(new ManualLayoutInspection(this).run((ModelView)view));
        }
        for (CustomView view : this.getWorkspace().getViews().getComponentViews()) {
            this.add(new GeneratedKeyInspection(this).run((View)view));
            this.add(new EmptyViewInspection(this).run((ModelView)view));
            this.add(new ManualLayoutInspection(this).run((ModelView)view));
        }
        for (CustomView view : this.getWorkspace().getViews().getDynamicViews()) {
            this.add(new GeneratedKeyInspection(this).run((View)view));
            this.add(new EmptyViewInspection(this).run((ModelView)view));
            this.add(new ManualLayoutInspection(this).run((ModelView)view));
        }
        for (CustomView view : this.getWorkspace().getViews().getDeploymentViews()) {
            this.add(new GeneratedKeyInspection(this).run((View)view));
            this.add(new EmptyViewInspection(this).run((ModelView)view));
            this.add(new ManualLayoutInspection(this).run((ModelView)view));
        }
        for (CustomView view : this.getWorkspace().getViews().getFilteredViews()) {
            this.add(new GeneratedKeyInspection(this).run((View)view));
        }
        for (CustomView view : this.getWorkspace().getViews().getImageViews()) {
            this.add(new GeneratedKeyInspection(this).run((View)view));
        }
        for (ElementStyle elementStyle : this.getWorkspace().getViews().getConfiguration().getStyles().getElements()) {
            this.add(new ElementStyleMetadataInspection(this).run(elementStyle));
        }
    }

    @Override
    public SeverityStrategy getSeverityStrategy() {
        return new PropertyBasedSeverityStrategy();
    }
}

