/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.inspection.view;

import com.structurizr.Workspace;
import com.structurizr.inspection.Inspector;
import com.structurizr.inspection.Violation;
import com.structurizr.inspection.view.AbstractViewsInspection;
import com.structurizr.view.SystemContextView;
import java.util.HashSet;

public class SystemContextViewsForMultipleSoftwareSystemsInspection
extends AbstractViewsInspection {
    public SystemContextViewsForMultipleSoftwareSystemsInspection(Inspector inspector) {
        super(inspector);
    }

    @Override
    protected Violation inspect(Workspace workspace) {
        HashSet<String> softwareSystemsWithSystemContextViews = new HashSet<String>();
        for (SystemContextView view : workspace.getViews().getSystemContextViews()) {
            softwareSystemsWithSystemContextViews.add(view.getSoftwareSystemId());
        }
        if (softwareSystemsWithSystemContextViews.size() > 1) {
            return this.violation("System context views exist for " + softwareSystemsWithSystemContextViews.size() + " software systems. It is recommended that a workspace includes system context views for a single software system only.");
        }
        return this.noViolation();
    }

    @Override
    protected String getType() {
        return "workspace.scope";
    }
}

