/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.inspection;

import com.structurizr.PropertyHolder;
import com.structurizr.Workspace;
import com.structurizr.inspection.Inspection;
import com.structurizr.inspection.Severity;
import com.structurizr.inspection.SeverityStrategy;
import com.structurizr.model.Element;
import com.structurizr.model.Model;
import com.structurizr.model.Relationship;
import com.structurizr.util.StringUtils;
import com.structurizr.view.ElementStyle;
import com.structurizr.view.View;
import com.structurizr.view.ViewSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PropertyBasedSeverityStrategy
implements SeverityStrategy {
    private static final String STRUCTURIZR_INSPECTION_PREFIX = "structurizr.inspection.";

    @Override
    public Severity getSeverity(Inspection inspection, Workspace workspace) {
        Severity severity = this.getSeverityFromProperties(inspection.getType(), new PropertyHolder[]{workspace});
        return severity != null ? severity : Severity.ERROR;
    }

    @Override
    public Severity getSeverity(Inspection inspection, ViewSet viewSet) {
        Severity severity = this.getSeverityFromProperties(inspection.getType(), new PropertyHolder[]{inspection.getWorkspace(), viewSet.getConfiguration()});
        return severity != null ? severity : Severity.ERROR;
    }

    @Override
    public Severity getSeverity(Inspection inspection, View view) {
        Severity severity = this.getSeverityFromProperties(inspection.getType(), new PropertyHolder[]{inspection.getWorkspace(), inspection.getWorkspace().getViews().getConfiguration(), view});
        return severity != null ? severity : Severity.ERROR;
    }

    @Override
    public Severity getSeverity(Inspection inspection, ElementStyle elementStyle) {
        Severity severity = this.getSeverityFromProperties(inspection.getType(), new PropertyHolder[]{inspection.getWorkspace(), inspection.getWorkspace().getViews().getConfiguration(), elementStyle});
        return severity != null ? severity : Severity.ERROR;
    }

    @Override
    public Severity getSeverity(Inspection inspection, Model model) {
        Severity severity = this.getSeverityFromProperties(inspection.getType(), new PropertyHolder[]{inspection.getWorkspace(), model});
        return severity != null ? severity : Severity.ERROR;
    }

    @Override
    public Severity getSeverity(Inspection inspection, Element element) {
        Severity severity;
        Element parentElement = element.getParent();
        Element grandParentElement = null;
        if (parentElement != null) {
            grandParentElement = parentElement.getParent();
        }
        return (severity = this.getSeverityFromProperties(inspection.getType(), new PropertyHolder[]{inspection.getWorkspace(), inspection.getWorkspace().getModel(), grandParentElement, parentElement, element})) != null ? severity : Severity.ERROR;
    }

    @Override
    public Severity getSeverity(Inspection inspection, Relationship relationship) {
        String destinationType;
        Element source = relationship.getSource();
        Object linkedRelationship = null;
        if (!StringUtils.isNullOrEmpty((String)relationship.getLinkedRelationshipId())) {
            inspection.getWorkspace().getModel().getRelationship(relationship.getLinkedRelationshipId());
        }
        String allRelationshipsType = inspection.getType();
        String specificRelationshipType = inspection.getType();
        String sourceType = relationship.getSource().getClass().getSimpleName().toLowerCase();
        specificRelationshipType = allRelationshipsType.replaceFirst("\\.relationship\\.", String.format(".relationship[%s->%s].", sourceType, destinationType = relationship.getDestination().getClass().getSimpleName().toLowerCase()));
        Severity severity = this.getSeverityFromProperties(specificRelationshipType, new PropertyHolder[]{inspection.getWorkspace(), inspection.getWorkspace().getModel(), source.getParent(), source, linkedRelationship, relationship});
        if (severity == null) {
            severity = this.getSeverityFromProperties(allRelationshipsType, new PropertyHolder[]{inspection.getWorkspace(), inspection.getWorkspace().getModel(), source.getParent(), source, linkedRelationship, relationship});
        }
        return severity != null ? severity : Severity.ERROR;
    }

    protected Severity getSeverityFromProperties(String type, PropertyHolder ... propertyHolders) {
        List<String> types = this.generatePropertyNames(type);
        List<PropertyHolder> reversedPropertyHolders = Arrays.asList(propertyHolders);
        Collections.reverse(reversedPropertyHolders);
        for (PropertyHolder propertyHolder : reversedPropertyHolders) {
            if (propertyHolder == null) continue;
            for (String t : types) {
                if (!propertyHolder.getProperties().containsKey(t)) continue;
                return Severity.valueOf(((String)propertyHolder.getProperties().get(t)).toUpperCase());
            }
        }
        return null;
    }

    protected List<String> generatePropertyNames(String type) {
        type = type.toLowerCase();
        ArrayList<String> types = new ArrayList<String>();
        String[] parts = type.split("\\.");
        Object buf = STRUCTURIZR_INSPECTION_PREFIX;
        types.add((String)buf + "*");
        for (int i = 0; i < parts.length - 1; ++i) {
            buf = (String)buf + parts[i] + ".";
            types.add((String)buf + "*");
        }
        types.add(STRUCTURIZR_INSPECTION_PREFIX + type);
        Collections.reverse(types);
        if (type.contains(".relationship[")) {
            return types.subList(0, types.size() - 2);
        }
        return types;
    }
}

