/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.inspection.model;

import com.structurizr.Workspace;
import com.structurizr.inspection.Inspector;
import com.structurizr.inspection.Violation;
import com.structurizr.inspection.model.AbstractModelInspection;
import com.structurizr.model.SoftwareSystem;

public class MultipleSoftwareSystemsDetailedInspection
extends AbstractModelInspection {
    public MultipleSoftwareSystemsDetailedInspection(Inspector inspector) {
        super(inspector);
    }

    @Override
    protected Violation inspect(Workspace workspace) {
        int softwareSystemsWithDetails = 0;
        for (SoftwareSystem softwareSystem : workspace.getModel().getSoftwareSystems()) {
            if (!softwareSystem.hasContainers() && softwareSystem.getDocumentation().isEmpty()) continue;
            ++softwareSystemsWithDetails;
        }
        if (softwareSystemsWithDetails > 1) {
            return this.violation("This workspace describes the internal details of " + softwareSystemsWithDetails + " software systems. It is recommended that a workspace contains the model, views, and documentation for a single software system only.");
        }
        return this.noViolation();
    }

    @Override
    protected String getType() {
        return "workspace.scope";
    }
}

