/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.inspection;

import com.structurizr.Workspace;
import com.structurizr.inspection.SeverityStrategy;
import com.structurizr.inspection.Violation;
import java.util.ArrayList;
import java.util.List;

public abstract class Inspector {
    private final Workspace workspace;
    private final List<Violation> violations = new ArrayList<Violation>();
    private int numberOfInspections = 0;

    protected Inspector(Workspace workspace) {
        this.workspace = workspace;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public List<Violation> getViolations() {
        return new ArrayList<Violation>(this.violations);
    }

    public int getNumberOfInspections() {
        return this.numberOfInspections;
    }

    protected void add(Violation violation) {
        ++this.numberOfInspections;
        if (violation != null) {
            this.violations.add(violation);
        }
    }

    public abstract SeverityStrategy getSeverityStrategy();
}

