/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.inspection.model;

import com.structurizr.inspection.Inspector;
import com.structurizr.inspection.Violation;
import com.structurizr.inspection.model.AbstractElementInspection;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.Relationship;
import java.util.HashSet;
import java.util.Set;

public class DisconnectedElementInspection
extends AbstractElementInspection {
    private final Set<String> elementsWithRelationships = new HashSet<String>();

    public DisconnectedElementInspection(Inspector inspector) {
        super(inspector);
        for (Relationship relationship : this.getWorkspace().getModel().getRelationships()) {
            this.elementsWithRelationships.add(relationship.getSourceId());
            this.elementsWithRelationships.add(relationship.getDestinationId());
        }
    }

    @Override
    protected Violation inspect(Element element) {
        if (element instanceof DeploymentNode) {
            return this.noViolation();
        }
        if (!this.elementsWithRelationships.contains(element.getId())) {
            return this.violation("The " + this.terminologyFor(element).toLowerCase() + " \"" + this.nameOf(element) + "\" is disconnected - add a relationship to/from it, or consider removing it from the model.");
        }
        return this.noViolation();
    }

    @Override
    protected String getType() {
        return "model.element.disconnected";
    }
}

