/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.inspection.view;

import com.structurizr.inspection.Inspection;
import com.structurizr.inspection.Inspector;
import com.structurizr.inspection.Severity;
import com.structurizr.inspection.Violation;
import com.structurizr.view.ElementStyle;

public class ElementStyleMetadataInspection
extends Inspection {
    public ElementStyleMetadataInspection(Inspector inspector) {
        super(inspector);
    }

    public final Violation run(ElementStyle elementStyle) {
        Severity severity = this.getInspector().getSeverityStrategy().getSeverity((Inspection)this, elementStyle);
        Violation violation = this.inspect(elementStyle);
        return violation == null ? null : violation.withSeverity(severity);
    }

    protected Violation inspect(ElementStyle elementStyle) {
        if (elementStyle.getMetadata() != null && !elementStyle.getMetadata().booleanValue()) {
            return this.violation("The element style for tag \"" + elementStyle.getTag() + "\" has metadata hidden, which may introduce ambiguity on rendered diagrams.");
        }
        return this.noViolation();
    }

    @Override
    protected String getType() {
        return "views.styles.element.metadata";
    }
}

