/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.io.plantuml;

import com.structurizr.io.plantuml.PlantUMLWriter;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystemInstance;
import com.structurizr.model.StaticStructureElementInstance;
import com.structurizr.util.StringUtils;
import com.structurizr.view.ComponentView;
import com.structurizr.view.ContainerView;
import com.structurizr.view.DynamicView;
import com.structurizr.view.ElementView;
import com.structurizr.view.RelationshipStyle;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.Shape;
import com.structurizr.view.View;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;

public class StructurizrPlantUMLWriter
extends PlantUMLWriter {
    public StructurizrPlantUMLWriter() {
        this.addSkinParam("shadowing", "false");
        this.addSkinParam("arrowFontSize", "10");
        this.addSkinParam("defaultTextAlignment", "center");
        this.addSkinParam("wrapWidth", "200");
        this.addSkinParam("maxMessageSize", "100");
    }

    @Override
    protected void write(ContainerView view, Writer writer) {
        try {
            this.writeHeader((View)view, writer);
            view.getElements().stream().filter(ev -> !(ev.getElement() instanceof Container)).map(ElementView::getElement).sorted(Comparator.comparing(Element::getName)).forEach(e -> this.write((View)view, (Element)e, writer, false));
            writer.write(String.format("package \"%s\\n%s\" {", view.getSoftwareSystem().getName(), this.typeOf((Element)view.getSoftwareSystem(), true)));
            writer.write(System.lineSeparator());
            view.getElements().stream().filter(ev -> ev.getElement() instanceof Container && ev.getElement().getParent().equals(view.getSoftwareSystem())).map(ElementView::getElement).sorted(Comparator.comparing(Element::getName)).forEach(e -> this.write((View)view, (Element)e, writer, true));
            writer.write("}");
            writer.write(System.lineSeparator());
            this.writeRelationships((View)view, writer);
            this.writeFooter(writer);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    protected void write(ComponentView view, Writer writer) {
        try {
            this.writeHeader((View)view, writer);
            view.getElements().stream().filter(ev -> !(ev.getElement() instanceof Component)).map(ElementView::getElement).sorted(Comparator.comparing(Element::getName)).forEach(e -> this.write((View)view, (Element)e, writer, false));
            writer.write(String.format("package \"%s\\n%s\" {", view.getContainer().getName(), this.typeOf((Element)view.getContainer(), true)));
            writer.write(System.lineSeparator());
            view.getElements().stream().filter(ev -> ev.getElement() instanceof Component && ev.getElement().getParent().equals(view.getContainer())).map(ElementView::getElement).sorted(Comparator.comparing(Element::getName)).forEach(e -> this.write((View)view, (Element)e, writer, true));
            writer.write("}");
            writer.write(System.lineSeparator());
            this.writeRelationships((View)view, writer);
            this.writeFooter(writer);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    protected void write(DynamicView view, Writer writer) {
        try {
            this.writeHeader((View)view, writer);
            LinkedHashSet<Element> elements = new LinkedHashSet<Element>();
            for (RelationshipView relationshipView : view.getRelationships()) {
                elements.add(relationshipView.getRelationship().getSource());
                elements.add(relationshipView.getRelationship().getDestination());
            }
            if (this.isUseSequenceDiagrams()) {
                elements.forEach(element -> {
                    try {
                        writer.write(String.format("%s \"%s\\n<size:10>%s</size>\" as %s <<%s>> %s%s", this.plantumlSequenceType((View)view, (Element)element), element.getName(), this.typeOf((Element)element, true), this.idOf((Element)element), this.idOf((Element)element), this.backgroundOf((View)view, (Element)element), System.lineSeparator()));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
                view.getRelationships().forEach(relationship -> {
                    try {
                        String arrowStart = "-";
                        String arrowEnd = ">";
                        if (relationship.isResponse().booleanValue()) {
                            arrowStart = "<-";
                            arrowEnd = "-";
                        }
                        writer.write(String.format("%s %s[%s]%s %s : %s. %s", this.idOf(relationship.getRelationship().getSource()), arrowStart, view.getViewSet().getConfiguration().getStyles().findRelationshipStyle(relationship.getRelationship()).getColor(), arrowEnd, this.idOf(relationship.getRelationship().getDestination()), relationship.getOrder(), this.hasValue(relationship.getDescription()) ? relationship.getDescription() : (this.hasValue(relationship.getRelationship().getDescription()) ? relationship.getRelationship().getDescription() : "")));
                        writer.write(System.lineSeparator());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            } else {
                elements.forEach(e -> this.write((View)view, (Element)e, writer, false));
                view.getRelationships().forEach(relationship -> this.writeRelationship((View)view, (RelationshipView)relationship, writer));
            }
            this.writeFooter(writer);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    protected void write(View view, DeploymentNode deploymentNode, Writer writer, int indent) {
        try {
            if (view.isElementInView((Element)deploymentNode)) {
                writer.write(String.format("%snode \"%s\\n%s\" <<%s>> as %s {", this.calculateIndent(indent), deploymentNode.getName() + (deploymentNode.getInstances() > 1 ? " (x" + deploymentNode.getInstances() + ")" : ""), this.typeOf((Element)deploymentNode, true), this.idOf((Element)deploymentNode), this.idOf((Element)deploymentNode)));
                writer.write(System.lineSeparator());
                ArrayList<DeploymentNode> children = new ArrayList<DeploymentNode>(deploymentNode.getChildren());
                children.sort(Comparator.comparing(Element::getName));
                for (DeploymentNode deploymentNode2 : children) {
                    if (!view.isElementInView((Element)deploymentNode2)) continue;
                    this.write(view, deploymentNode2, writer, indent + 1);
                }
                ArrayList<InfrastructureNode> infrastructureNodes = new ArrayList<InfrastructureNode>(deploymentNode.getInfrastructureNodes());
                infrastructureNodes.sort(Comparator.comparing(Element::getName));
                for (InfrastructureNode infrastructureNode : infrastructureNodes) {
                    if (!view.isElementInView((Element)infrastructureNode)) continue;
                    this.write(view, (Element)infrastructureNode, writer, indent + 1);
                }
                ArrayList<ContainerInstance> arrayList = new ArrayList<ContainerInstance>(deploymentNode.getContainerInstances());
                arrayList.sort(Comparator.comparing(StaticStructureElementInstance::getName));
                for (ContainerInstance containerInstance : arrayList) {
                    if (!view.isElementInView((Element)containerInstance)) continue;
                    this.write(view, (Element)containerInstance, writer, indent + 1);
                }
                ArrayList<SoftwareSystemInstance> arrayList2 = new ArrayList<SoftwareSystemInstance>(deploymentNode.getSoftwareSystemInstances());
                arrayList2.sort(Comparator.comparing(StaticStructureElementInstance::getName));
                for (SoftwareSystemInstance softwareSystemInstance : arrayList2) {
                    if (!view.isElementInView((Element)softwareSystemInstance)) continue;
                    this.write(view, (Element)softwareSystemInstance, writer, indent + 1);
                }
                writer.write(String.format("%s}", this.calculateIndent(indent)));
                writer.write(System.lineSeparator());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void write(View view, Element element, Writer writer, int indent) {
        try {
            String shape = this.plantUMLShapeOf(view, element);
            if ("actor".equals(shape)) {
                shape = "rectangle";
            }
            String name = element.getName();
            String description = element.getDescription();
            String type = this.typeOf(element, true);
            if (element instanceof StaticStructureElementInstance) {
                StaticStructureElementInstance elementInstance = (StaticStructureElementInstance)element;
                name = elementInstance.getElement().getName();
                description = elementInstance.getElement().getDescription();
                type = this.typeOf((Element)elementInstance.getElement(), true);
                shape = this.plantUMLShapeOf(view, (Element)elementInstance.getElement());
            }
            String prefix = this.calculateIndent(indent);
            String separator = System.lineSeparator();
            String id = this.idOf(element);
            writer.write(String.format("%s%s \"==%s\\n<size:10>%s</size>%s\" <<%s>> as %s%s", prefix, shape, name, type, StringUtils.isNullOrEmpty((String)description) ? "" : "\\n\\n" + description, id, id, separator));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void writeRelationship(View view, RelationshipView relationshipView, Writer writer) {
        String description = "";
        if (!StringUtils.isNullOrEmpty((String)relationshipView.getOrder())) {
            description = relationshipView.getOrder() + ". ";
        }
        description = description + (this.hasValue(relationshipView.getDescription()) ? relationshipView.getDescription() : (this.hasValue(relationshipView.getRelationship().getDescription()) ? relationshipView.getRelationship().getDescription() : ""));
        try {
            String arrowEnd;
            String arrowStart;
            Relationship relationship = relationshipView.getRelationship();
            RelationshipStyle style = this.relationshipStyleOf(view, relationship);
            if (style.getDashed() == null) {
                style.setDashed(Boolean.valueOf(true));
            }
            String relationshipStyle = style.getColor();
            if (style.getThickness() != null) {
                relationshipStyle = relationshipStyle + ",thickness=" + style.getThickness();
            }
            if (relationshipView.isResponse() != null && relationshipView.isResponse().booleanValue()) {
                arrowStart = style.getDashed() != false ? "<." : "<-";
                arrowEnd = style.getDashed() != false ? "." : "-";
            } else {
                arrowStart = style.getDashed() != false ? "." : "-";
                arrowEnd = style.getDashed() != false ? ".>" : "->";
            }
            writer.write(String.format("%s %s[%s]%s %s : \"%s%s\"%s", this.idOf(relationship.getSource()), arrowStart, relationshipStyle, arrowEnd, this.idOf(relationship.getDestination()), description, StringUtils.isNullOrEmpty((String)relationship.getTechnology()) ? "" : "\\n<size:8>[" + relationship.getTechnology() + "]</size>", System.lineSeparator()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void writeHeader(View view, Writer writer) throws IOException {
        super.writeHeader(view, writer);
        writer.write("hide stereotype");
        writer.write(System.lineSeparator());
        if (!(view instanceof DynamicView && this.isUseSequenceDiagrams() || view.getAutomaticLayout() == null)) {
            switch (view.getAutomaticLayout().getRankDirection()) {
                case LeftRight: {
                    writer.write("left to right direction");
                    break;
                }
                default: {
                    writer.write("top to bottom direction");
                }
            }
            writer.write(System.lineSeparator());
        }
        for (ElementView elementView : view.getElements()) {
            String type;
            Element element = elementView.getElement();
            String id = this.idOf(element);
            if (element instanceof StaticStructureElementInstance) {
                element = ((StaticStructureElementInstance)element).getElement();
            }
            if ("actor".equals(type = this.plantUMLShapeOf(view, element))) {
                type = "rectangle";
            }
            String background = this.backgroundOf(view, element);
            String stroke = this.strokeOf(view, element);
            String color = this.colorOf(view, element);
            Shape shape = this.shapeOf(view, element);
            if (view instanceof DynamicView && this.isUseSequenceDiagrams()) {
                type = "sequenceParticipant";
            }
            writer.write(String.format("skinparam %s<<%s>> {%s", type, id, System.lineSeparator()));
            if (element instanceof DeploymentNode) {
                writer.write(String.format("  BackgroundColor #ffffff%s", System.lineSeparator()));
            } else {
                writer.write(String.format("  BackgroundColor %s%s", background, System.lineSeparator()));
            }
            writer.write(String.format("  FontColor %s%s", color, System.lineSeparator()));
            writer.write(String.format("  BorderColor %s%s", stroke, System.lineSeparator()));
            if (shape == Shape.RoundedBox) {
                writer.write(String.format("  roundCorner 20%s", System.lineSeparator()));
            }
            writer.write(String.format("}%s", System.lineSeparator()));
        }
    }
}

