/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.io.plantuml;

import com.structurizr.io.plantuml.BasicPlantUMLWriter;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.Element;
import com.structurizr.model.Location;
import com.structurizr.model.Person;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.SoftwareSystemInstance;
import com.structurizr.view.ComponentView;
import com.structurizr.view.ContainerView;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.View;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class C4PlantUMLWriter
extends BasicPlantUMLWriter {
    private static final Logger logger = Logger.getLogger(C4PlantUMLWriter.class.getName());
    public static final String C4_LAYOUT_DIRECTION = "c4:layout:direction";
    public static final String C4_LAYOUT_MODE = "c4:layout:mode";
    public static final String C4_ELEMENT_TYPE = "c4:element:type";

    public static Collection<String> inferC4PlantUMLLibraryFrom(String urlText) {
        try {
            URL url = C4PlantUMLWriter.canonicalizeUrl(urlText);
            return Arrays.asList("C4.puml", "C4_Context.puml", "C4_Container.puml", "C4_Component.puml").stream().map(file -> {
                try {
                    return new URL(url, (String)file);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(String.format("Unable to create C4-PlantUML libray object from %s", urlText), e);
                }
            }).map(fileUrl -> fileUrl.toExternalForm()).collect(Collectors.toList());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(String.format("Unable to create C4-PlantUML libray object from %s", urlText), e);
        }
    }

    static URL canonicalizeUrl(String urlText) throws MalformedURLException {
        URL url = new URL(urlText);
        if (url.getHost().equals("github.com")) {
            String path = url.getPath().substring(1);
            String[] fragments = path.split("/");
            if (fragments.length < 2) {
                throw new RuntimeException(String.format("The path you gave (%s) in you URL is wrong, as it is not a GitHub user repo but %s", path, urlText));
            }
            String user = fragments[0];
            String repo = fragments[1];
            String branch = "master";
            if (fragments.length > 2) {
                if ("tree".equals(fragments[2])) {
                    if (fragments.length == 4) {
                        branch = fragments[3];
                    }
                } else {
                    throw new RuntimeException(String.format("We don't know how to parse url %s. Please enter a bug report.", urlText));
                }
            }
            url = new URL(url.getProtocol(), url.getHost(), String.format("/%s/%s/tree/%s/", user, repo, branch));
            url = new URL(url.getProtocol(), "raw.githubusercontent.com", url.getPath().replace("/tree/", "/"));
        }
        return url;
    }

    public C4PlantUMLWriter() {
        this(Layout.LAYOUT_WITH_LEGEND, "https://github.com/plantuml-stdlib/C4-PlantUML");
    }

    public C4PlantUMLWriter(Layout layout, String c4PlantUMLBaseUrl) {
        this(layout, C4PlantUMLWriter.inferC4PlantUMLLibraryFrom(c4PlantUMLBaseUrl));
    }

    public C4PlantUMLWriter(Layout layout, Collection<String> c4PlantUMLIncludes) {
        try {
            for (String url : c4PlantUMLIncludes) {
                this.addIncludeURL(new URI(url));
            }
            this.getIncludes().add(String.format("%s()\n", layout.name()));
        }
        catch (URISyntaxException e) {
            logger.log(Level.SEVERE, "Using C4-PlantUML should not trigger URI error", e);
        }
        this.clearSkinParams();
    }

    @Override
    protected void writeContainerForSoftwareSystem(ContainerView view, Writer writer, BiConsumer<ContainerView, Writer> packageContentWriter) throws IOException {
        writer.write(String.format("System_Boundary(%s_boundary, %s) {", view.getSoftwareSystemId(), view.getSoftwareSystem().getName()));
        writer.write(System.lineSeparator());
        packageContentWriter.accept(view, writer);
        writer.write("}");
        writer.write(System.lineSeparator());
    }

    @Override
    protected void writeContainerForContainer(ComponentView view, Writer writer, BiConsumer<ComponentView, Writer> packageContentWriter) throws IOException {
        writer.write(String.format("Container_Boundary(%s_boundary, %s) {", view.getContainerId(), view.getContainer().getName()));
        writer.write(System.lineSeparator());
        packageContentWriter.accept(view, writer);
        writer.write("}");
        writer.write(System.lineSeparator());
    }

    @Override
    protected void write(View view, Element element, Writer writer, int indent) {
        try {
            String prefix = this.calculateIndent(indent);
            this.getWriterFor(element).write(view, element, writer, prefix);
        }
        catch (NoMacroFound noMacro) {
            super.write(view, element, writer, indent);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private C4ElementWriter getWriterFor(Element element) {
        if (element instanceof Person) {
            return new PersonWriter();
        }
        if (element instanceof SoftwareSystem) {
            return new SoftwareSystemWriter();
        }
        if (element instanceof Container) {
            return new ContainerWriter();
        }
        if (element instanceof SoftwareSystemInstance) {
            return new SoftwareSystemInstanceWriter();
        }
        if (element instanceof ContainerInstance) {
            return new ContainerInstanceWriter();
        }
        if (element instanceof Component) {
            return new ComponentWriter();
        }
        throw new NoMacroFound();
    }

    @Override
    protected void writeRelationship(View view, RelationshipView relationshipView, Writer writer) {
        Relationship relationship = relationshipView.getRelationship();
        Element source = relationship.getSource();
        Element destination = relationship.getDestination();
        if (relationshipView.isResponse() != null && relationshipView.isResponse().booleanValue()) {
            source = relationship.getDestination();
            destination = relationship.getSource();
        }
        try {
            String separator = System.lineSeparator();
            String relationshipMacro = null;
            RelationshipModes mode = RelationshipModes.Rel;
            if (relationship.getProperties().containsKey(C4_LAYOUT_MODE)) {
                mode = RelationshipModes.valueOf((String)relationship.getProperties().get(C4_LAYOUT_MODE));
            }
            switch (mode) {
                case Lay: 
                case Rel: {
                    relationshipMacro = mode.name();
                    Directions direction = Directions.Down;
                    if (relationship.getProperties().containsKey(C4_LAYOUT_DIRECTION)) {
                        direction = Directions.valueOf((String)relationship.getProperties().get(C4_LAYOUT_DIRECTION));
                    }
                    relationshipMacro = String.format("%s_%s", relationshipMacro, direction.forMacro());
                    break;
                }
                default: {
                    relationshipMacro = String.format("Rel_%s", new Object[]{mode});
                }
            }
            if (mode == RelationshipModes.Lay) {
                writer.write(String.format("%s(%s, %s)%s", relationshipMacro, this.idOf(source), this.idOf(destination), separator));
            } else if (relationship.getDescription() == null) {
                writer.write(String.format("%s(%s, %s)%s", relationshipMacro, this.idOf(source), this.idOf(destination), separator));
            } else if (relationship.getTechnology() == null) {
                writer.write(String.format("%s(%s, %s, \"%s\")%s", relationshipMacro, this.idOf(source), this.idOf(destination), relationship.getDescription(), separator));
            } else {
                writer.write(String.format("%s(%s, %s, \"%s\", \"%s\")%s", relationshipMacro, this.idOf(source), this.idOf(destination), relationship.getDescription(), relationship.getTechnology(), separator));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class ContainerInstanceWriter
    extends C4ElementWriter<ContainerInstance> {
        private ContainerInstanceWriter() {
        }

        @Override
        void doWrite(View view, ContainerInstance element, Writer writer, String prefix, String id, String separator) throws IOException {
            if (!view.isElementInView((Element)element)) {
                return;
            }
            Type type = Type.valueOf(element.getProperties().getOrDefault(C4PlantUMLWriter.C4_ELEMENT_TYPE, element.getContainer().getProperties().getOrDefault(C4PlantUMLWriter.C4_ELEMENT_TYPE, Type.Default.name())));
            String macro = String.format("Container%s", type == Type.Default ? "" : type.name());
            writer.write(String.format("%s%s(%s, \"%s\", \"%s\", \"%s\")%s", prefix, macro, id, element.getContainer().getName(), element.getContainer().getTechnology(), element.getContainer().getDescription(), separator));
        }
    }

    private class SoftwareSystemInstanceWriter
    extends C4ElementWriter<SoftwareSystemInstance> {
        private SoftwareSystemInstanceWriter() {
        }

        @Override
        void doWrite(View view, SoftwareSystemInstance element, Writer writer, String prefix, String id, String separator) throws IOException {
            if (!view.isElementInView((Element)element)) {
                return;
            }
            boolean internal = !element.getSoftwareSystem().getLocation().equals((Object)Location.External);
            Type type = Type.valueOf(element.getProperties().getOrDefault(C4PlantUMLWriter.C4_ELEMENT_TYPE, element.getSoftwareSystem().getProperties().getOrDefault(C4PlantUMLWriter.C4_ELEMENT_TYPE, Type.Default.name())));
            String macro = String.format("System%s%s", type == Type.Default ? "" : type.name(), internal ? "" : "_Ext");
            writer.write(String.format("%s%s(%s, \"%s\", \"%s\")%s", prefix, macro, id, element.getSoftwareSystem().getName(), element.getSoftwareSystem().getDescription(), separator));
        }
    }

    private class ComponentWriter
    extends C4ElementWriter<Component> {
        private ComponentWriter() {
        }

        @Override
        void doWrite(View view, Component element, Writer writer, String prefix, String id, String separator) throws IOException {
            Type type = Type.valueOf(element.getProperties().getOrDefault(C4PlantUMLWriter.C4_ELEMENT_TYPE, Type.Default.name()));
            String macro = String.format("Component%s", type == Type.Default ? "" : type.name());
            writer.write(String.format("%s%s(%s, \"%s\", \"%s\", \"%s\")%s", prefix, macro, id, element.getName(), element.getTechnology(), element.getDescription(), separator));
        }
    }

    private class ContainerWriter
    extends C4ElementWriter<Container> {
        private ContainerWriter() {
        }

        @Override
        void doWrite(View view, Container element, Writer writer, String prefix, String id, String separator) throws IOException {
            Type type = Type.valueOf(element.getProperties().getOrDefault(C4PlantUMLWriter.C4_ELEMENT_TYPE, Type.Default.name()));
            String macro = String.format("Container%s", type == Type.Default ? "" : type.name());
            writer.write(String.format("%s%s(%s, \"%s\", \"%s\", \"%s\")%s", prefix, macro, id, element.getName(), element.getTechnology(), element.getDescription(), separator));
        }
    }

    private class SoftwareSystemWriter
    extends C4ElementWriter<SoftwareSystem> {
        private SoftwareSystemWriter() {
        }

        @Override
        void doWrite(View view, SoftwareSystem element, Writer writer, String prefix, String id, String separator) throws IOException {
            boolean internal = !element.getLocation().equals((Object)Location.External);
            Type type = Type.valueOf(element.getProperties().getOrDefault(C4PlantUMLWriter.C4_ELEMENT_TYPE, Type.Default.name()));
            String macro = String.format("System%s%s", type == Type.Default ? "" : type.name(), internal ? "" : "_Ext");
            writer.write(String.format("%s%s(%s, \"%s\", \"%s\")%s", prefix, macro, id, element.getName(), element.getDescription(), separator));
        }
    }

    private class PersonWriter
    extends C4ElementWriter<Person> {
        private PersonWriter() {
        }

        @Override
        void doWrite(View view, Person element, Writer writer, String prefix, String id, String separator) throws IOException {
            String macro = null;
            switch (element.getLocation()) {
                case External: {
                    macro = "Person_Ext";
                    break;
                }
                default: {
                    macro = "Person";
                }
            }
            writer.write(String.format("%s%s(%s, \"%s\", \"%s\")%s", prefix, macro, id, element.getName(), element.getDescription(), separator));
        }
    }

    private abstract class C4ElementWriter<WrittenElement extends Element> {
        private C4ElementWriter() {
        }

        public void write(View view, WrittenElement element, Writer writer, String prefix) throws IOException {
            String id = C4PlantUMLWriter.this.idOf((Element)element);
            String separator = System.lineSeparator();
            this.doWrite(view, element, writer, prefix, id, separator);
        }

        abstract void doWrite(View var1, WrittenElement var2, Writer var3, String var4, String var5, String var6) throws IOException;
    }

    public static class NoMacroFound
    extends RuntimeException {
    }

    public static enum RelationshipModes {
        Rel,
        Neighbor,
        Back,
        Back_Neighbor,
        Lay;

    }

    public static enum Directions {
        Up,
        Down,
        Right,
        Left;


        public String forMacro() {
            return this.name().substring(0, 1);
        }
    }

    public static enum Type {
        Default,
        Db;

    }

    public static enum Layout {
        LAYOUT_TOP_DOWN,
        LAYOUT_LEFT_RIGHT,
        LAYOUT_WITH_LEGEND,
        LAYOUT_AS_SKETCH;

    }
}

