/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.analysis;

import com.structurizr.analysis.AbstractComponentFinderStrategy;
import com.structurizr.analysis.SupportingTypesStrategy;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractSpringComponentFinderStrategy
extends AbstractComponentFinderStrategy {
    public static final String SPRING_MVC_CONTROLLER = "Spring MVC Controller";
    public static final String SPRING_SERVICE = "Spring Service";
    public static final String SPRING_REPOSITORY = "Spring Repository";
    public static final String SPRING_COMPONENT = "Spring Component";
    public static final String SPRING_REST_CONTROLLER = "Spring REST Controller";
    public static final String SPRING_WEB_SERVICE_ENDPOINT = "Spring Web Service";
    protected boolean includePublicTypesOnly = true;

    public AbstractSpringComponentFinderStrategy(SupportingTypesStrategy ... strategies) {
        super(strategies);
    }

    protected Set<Component> findInterfacesForImplementationClassesWithAnnotation(Class<? extends Annotation> type, String technology) {
        HashSet<Component> components = new HashSet<Component>();
        Container container = this.getComponentFinder().getContainer();
        Set annotatedTypes = this.findTypesAnnotatedWith(type);
        for (Class<?> annotatedType : annotatedTypes) {
            Component newComponent;
            if (container.getComponentWithName(annotatedType.getSimpleName()) != null) continue;
            if (annotatedType.isInterface()) {
                Component newComponent2 = this.addComponent(container, annotatedType.getSimpleName(), annotatedType.getCanonicalName(), "", technology);
                if (newComponent2 == null) continue;
                components.add(newComponent2);
                continue;
            }
            String componentName = annotatedType.getSimpleName();
            Class<?> componentType = annotatedType;
            boolean foundInterface = false;
            if (annotatedType.getInterfaces().length > 0) {
                for (Class<?> interfaceType : annotatedType.getInterfaces()) {
                    String interfaceName = interfaceType.getSimpleName();
                    if (!componentName.startsWith(interfaceName) && !componentName.endsWith(interfaceName) && !componentName.contains(interfaceName)) continue;
                    componentName = interfaceName;
                    componentType = interfaceType;
                    foundInterface = true;
                    break;
                }
            }
            if (this.includePublicTypesOnly && !Modifier.isPublic(componentType.getModifiers()) || (newComponent = this.addComponent(container, componentName, componentType.getCanonicalName(), "", technology)) == null) continue;
            components.add(newComponent);
            if (!foundInterface) continue;
            newComponent.addSupportingType(annotatedType.getCanonicalName());
        }
        return components;
    }

    public void setIncludePublicTypesOnly(boolean includePublicTypesOnly) {
        this.includePublicTypesOnly = includePublicTypesOnly;
    }
}

