/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.io.websequencediagrams;

import com.structurizr.Workspace;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.Element;
import com.structurizr.model.InteractionStyle;
import com.structurizr.model.Person;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.view.DynamicView;
import com.structurizr.view.RelationshipView;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashSet;

public final class WebSequenceDiagramsWriter {
    private static final String SYNCHRONOUS_INTERACTION = "->";
    private static final String ASYNCHRONOUS_INTERACTION = "->>";
    private static final String SYNCHRONOUS_INTERACTION_RETURN = "-->";
    private static final String ASYNCHRONOUS_INTERACTION_RETURN = "-->>";

    public String toString(DynamicView view) {
        StringWriter stringWriter = new StringWriter();
        this.write(view, (Writer)stringWriter);
        return stringWriter.toString();
    }

    public void write(Workspace workspace, Writer writer) {
        if (workspace != null && writer != null) {
            for (DynamicView view : workspace.getViews().getDynamicViews()) {
                this.write(view, writer);
            }
        }
    }

    public void write(Workspace workspace) {
        StringWriter stringWriter = new StringWriter();
        this.write(workspace, (Writer)stringWriter);
        System.out.println(stringWriter.toString());
    }

    public void write(DynamicView view, Writer writer) {
        try {
            writer.write("title " + view.getName() + " - " + view.getKey());
            writer.write(System.lineSeparator());
            writer.write(System.lineSeparator());
            LinkedHashSet<Element> elements = new LinkedHashSet<Element>();
            for (RelationshipView relationshipView : view.getRelationships()) {
                elements.add(relationshipView.getRelationship().getSource());
                elements.add(relationshipView.getRelationship().getDestination());
            }
            for (Element element : elements) {
                if (element instanceof Person) {
                    writer.write(String.format("actor <<Person>>>\\n%s as %s", element.getName(), element.getName()));
                    writer.write(System.lineSeparator());
                    continue;
                }
                if (element instanceof SoftwareSystem) {
                    writer.write(String.format("participant <<Software System>>>\\n%s as %s", element.getName(), element.getName()));
                    writer.write(System.lineSeparator());
                    continue;
                }
                if (element instanceof Container) {
                    writer.write(String.format("participant <<Container>>>\\n%s as %s", element.getName(), element.getName()));
                    writer.write(System.lineSeparator());
                    continue;
                }
                if (!(element instanceof Component)) continue;
                writer.write(String.format("participant <<Component>>>\\n%s as %s", element.getName(), element.getName()));
                writer.write(System.lineSeparator());
            }
            writer.write(System.lineSeparator());
            for (RelationshipView relationshipView : view.getRelationships()) {
                String arrow;
                Relationship r = relationshipView.getRelationship();
                Element source = r.getSource();
                Element destination = r.getDestination();
                String string = arrow = r.getInteractionStyle() == InteractionStyle.Asynchronous ? ASYNCHRONOUS_INTERACTION : SYNCHRONOUS_INTERACTION;
                if (relationshipView.isResponse() != null && relationshipView.isResponse().booleanValue()) {
                    source = r.getDestination();
                    destination = r.getSource();
                    arrow = r.getInteractionStyle() == InteractionStyle.Asynchronous ? ASYNCHRONOUS_INTERACTION_RETURN : SYNCHRONOUS_INTERACTION_RETURN;
                }
                writer.write(String.format("%s%s%s: %s", source.getName(), arrow, destination.getName(), relationshipView.getDescription()));
                writer.write(System.lineSeparator());
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void toStdOut(Workspace workspace) {
        if (workspace == null) {
            throw new IllegalArgumentException("A workspace must be provided.");
        }
        StringWriter stringWriter = new StringWriter();
        this.write(workspace, (Writer)stringWriter);
        System.out.println(stringWriter.toString());
    }
}

