/*
 * Decompiled with CFR 0.152.
 */
package invar.lib;

import invar.lib.CodecError;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public abstract class InvarCodec {
    private static BigInteger UINT64_MAX = new BigInteger("FFFFFFFFFFFFFFFF", 16);

    public static boolean overRangeUInt64(BigInteger value) {
        return value.compareTo(BigInteger.ZERO) < 0 || value.compareTo(UINT64_MAX) > 0;
    }

    public static interface ResponseSender {
        public void sendResponse(ProtocResponse var1) throws IOException;
    }

    public static interface ProtocResponse
    extends InvarProtoc {
        public Integer getProtocError();

        public void setProtocError(Integer var1);
    }

    public static interface ProtocRequest
    extends InvarProtoc {
    }

    public static interface ProtocNotify
    extends InvarProtoc {
    }

    public static interface InvarProtoc
    extends BinaryDecode,
    BinaryEncode,
    XMLEncode,
    JSONEncode {
        public Integer getProtocId();

        public Long getProtocCRC();
    }

    public static interface XMLEncode {
        public String toStringXML();

        public void writeXML(StringBuilder var1, String var2);
    }

    public static interface JSONEncode {
        public String toStringJSON();

        public void writeJSON(StringBuilder var1);
    }

    public static interface BinaryDecode {
        public void read(InputStream var1) throws IOException, CodecError;

        public void read(DataInput var1) throws IOException, CodecError;
    }

    public static interface BinaryEncode {
        public void write(OutputStream var1) throws IOException;

        public void write(DataOutput var1) throws IOException;
    }
}

