/*
 * Decompiled with CFR 0.152.
 */
package invar.lib;

import invar.lib.InvarSQL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class InvarMySQL
extends InvarSQL {
    public InvarMySQL(String tableName, List<String> writable, Map<String, String> fieldMap) {
        super(tableName, writable, fieldMap);
    }

    @Override
    public final String jdbcDriver() {
        return "com.mysql.jdbc.Driver";
    }

    @Override
    public StringBuilder buildInsert() {
        StringBuilder s = new StringBuilder(512);
        StringBuilder v = new StringBuilder(256);
        s.append("INSERT INTO ");
        s.append('`').append(this.tableName).append('`');
        s.append(' ').append('(');
        int len = this.writable.size();
        for (int i = 0; i < len; ++i) {
            String field = this.writable.get(i);
            s.append('`').append(field).append('`');
            v.append('?');
            if (i >= len - 1) continue;
            s.append(',');
            v.append(',');
        }
        s.append(')');
        s.append(" VALUES ");
        s.append('(').append((CharSequence)v).append(')');
        return s;
    }

    @Override
    public StringBuilder buildSelect(String where, int pageNumber, int pageSize, String ... fields) {
        int offset = pageSize * (Math.max(0, pageNumber) - 1);
        StringBuilder s = this.buildSelect(where, -1, fields);
        s.append(" LIMIT ");
        s.append(Math.max(1, pageSize));
        if (offset >= 0) {
            s.append(" OFFSET ");
            s.append(Math.max(0, offset));
        }
        return s;
    }

    @Override
    public StringBuilder buildSelect(String where, int limit, String ... fields) {
        StringBuilder s = new StringBuilder(512);
        List<String> filtered = this.filterFields(fields);
        if (filtered == null || filtered.size() <= 0) {
            return s;
        }
        s.append("SELECT ");
        int len = filtered.size();
        for (int i = 0; i < len; ++i) {
            String field = filtered.get(i);
            String name = (String)this.fieldMap.get(field);
            s.append('`').append(field).append('`');
            if (!name.equals(field)) {
                s.append("AS");
                s.append('`').append(name).append('`');
            }
            if (i >= len - 1) continue;
            s.append(',');
        }
        s.append(" FROM ");
        s.append('`').append(this.tableName).append('`');
        this.buildWhereClause(s, where);
        if (limit > 0) {
            s.append(" LIMIT ").append(limit);
        }
        return s;
    }

    @Override
    public StringBuilder buildUpdate(String where, String ... fields) {
        StringBuilder s = new StringBuilder(512);
        List<String> filtered = this.filterFields(fields);
        if (filtered.size() <= 0) {
            return s;
        }
        ArrayList<String> result = new ArrayList<String>(filtered.size());
        for (String field : filtered) {
            if (!this.writable.contains(field)) continue;
            result.add(field);
        }
        if (result.size() <= 0) {
            return s;
        }
        s.append("UPDATE ");
        s.append('`').append(this.tableName).append('`');
        s.append(" SET ");
        int len = result.size();
        for (int i = 0; i < len; ++i) {
            String field = (String)result.get(i);
            s.append('`').append(field).append('`');
            s.append('=').append('?');
            if (i >= len - 1) continue;
            s.append(',');
        }
        this.buildWhereClause(s, where);
        return s;
    }

    private void buildWhereClause(StringBuilder s, String where) {
        if (where == null || where.length() <= 0) {
            return;
        }
        s.append(" WHERE ");
        s.append(where);
    }

    private List<String> filterFields(String ... fields) {
        HashSet includes = new HashSet(fields.length);
        Collections.addAll(includes, fields);
        ArrayList<String> filtered = new ArrayList<String>(this.fieldMap.size());
        for (Map.Entry i : this.fieldMap.entrySet()) {
            String k = (String)i.getKey();
            String v = (String)i.getValue();
            if (includes.size() > 0 && !includes.contains(k) && !includes.contains(v)) continue;
            filtered.add(k);
        }
        return filtered;
    }
}

