/*
 * Decompiled with CFR 0.152.
 */
package invar.lib;

import invar.lib.InvarCodec;
import invar.lib.RecvContext;
import java.util.HashMap;
import java.util.Map;

public abstract class RecvRequest<T extends InvarCodec.ProtocRequest, R extends InvarCodec.ProtocResponse> {
    private static Map<String, RecvRequest> map = new HashMap<String, RecvRequest>(256);
    private String id = null;

    public static <T extends InvarCodec.ProtocRequest, R extends InvarCodec.ProtocResponse, C extends RecvContext> void recv(C ctx, T req, R resp) {
        String key = ctx.handlerId();
        if (key == null || key.length() <= 0) {
            key = req.getProtocId().toString();
        }
        if (map.containsKey(key)) {
            RecvRequest recv = map.get(key);
            recv.handle(req, resp, ctx);
        } else {
            resp.setProtocError(503);
        }
    }

    public static <T extends InvarCodec.ProtocRequest> String getSessionId(T req, RecvContext ctx) {
        String key = ctx.handlerId();
        if (map.containsKey(key)) {
            RecvRequest recv = map.get(key);
            return recv.sessionId(req);
        }
        return null;
    }

    public abstract void handle(T var1, R var2, RecvContext var3);

    protected void setHandlerId(String id) {
        if (this.id != null) {
            map.remove(this.id);
        }
        if (id != null && id.length() > 0 && !map.containsKey(id)) {
            map.put(id, this);
        }
    }

    protected String sessionId(T req) {
        return null;
    }
}

