/*
 * Decompiled with CFR 0.152.
 */
package invar.lib.data;

import invar.lib.data.DataNode;
import invar.lib.data.DataParser;
import invar.lib.data.DataParserJson;
import invar.lib.data.DataParserXml;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class DataMapper {
    private final DataParser parser;
    private String path;
    private Boolean verbose = false;
    private Boolean shortenMapEntry = true;
    private static int maxRecursiveFiles = 8096;
    private static final Charset UTF8 = Charset.forName("utf-8");
    private static final HashMap<Class<?>, HashMap<String, Method>> mapClassSetters = new HashMap();
    private static final HashMap<Class<?>, HashMap<String, Method>> mapClassGetters = new HashMap();
    private static final HashMap<Class<?>, Method> mapEnumGetters = new HashMap();
    private static final String GENERIC_SPLIT = ",";
    private static final String GENERIC_LEFT = "<";
    private static final String GENERIC_RIGHT = ">";
    private static final String PREFIX_SETTER = "set";
    private static final String PREFIX_GETTER = "get";
    private static final String ATTR_MAP_KEY = "key";
    private static final String ATTR_VALUE = "value";

    public static DataMapper forJson() {
        return new DataMapper(new DataParserJson()).setVerbose(false);
    }

    public static DataMapper forXml() {
        return new DataMapper(new DataParserXml()).setVerbose(false);
    }

    public static void setMaxRecursiveFiles(int maxRecursiveFiles) {
        DataMapper.maxRecursiveFiles = Math.max(1, maxRecursiveFiles);
    }

    public static void mapFiles(Object root, String dir, final String suffix) throws Exception {
        File file = new File(dir);
        if (!file.exists()) {
            throw new IOException("Path doesn't exist:\n" + file.getAbsolutePath());
        }
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File f = new File(dir, name);
                return f.isDirectory() && !f.getName().startsWith(".") && !f.getName().startsWith("_") || name.endsWith(suffix);
            }
        };
        ArrayList<File> files = new ArrayList<File>();
        DataMapper.recursiveReadFile(files, file, filter);
        for (File f : files) {
            String path = f.getAbsolutePath();
            if (suffix.endsWith("xml")) {
                DataMapper.forXml().setPath(path).map(root, new FileInputStream(f));
                DataMapper.log("Read <- " + path);
                continue;
            }
            if (!suffix.endsWith("json")) continue;
            DataMapper.forJson().setPath(path).map(root, new FileInputStream(f));
            DataMapper.log("Read <- " + path);
        }
    }

    private static void recursiveReadFile(List<File> all, File file, FilenameFilter filter) {
        if (all.size() > maxRecursiveFiles) {
            return;
        }
        if (file.isFile()) {
            all.add(file);
        } else if (file.isDirectory()) {
            File[] files = file.listFiles(filter);
            assert (files != null);
            for (File file1 : files) {
                DataMapper.recursiveReadFile(all, file1, filter);
            }
        }
    }

    public DataMapper(DataParser parser) {
        this.parser = parser;
    }

    public <T> T map(T dest, String from) throws Exception {
        if (from == null || from.length() <= 0) {
            return dest;
        }
        byte[] bytes = from.getBytes(UTF8);
        ByteArrayInputStream i = new ByteArrayInputStream(bytes);
        return this.map(dest, i);
    }

    public <T> T map(T dest, InputStream from) throws Exception {
        if (null == from) {
            return dest;
        }
        if (null == dest) {
            return null;
        }
        DataNode node = this.parser.parse(from);
        assert (node != null);
        this.parse(dest, node);
        return dest;
    }

    private void parse(Object o, DataNode n) throws Exception {
        this.parse(o, n, o.getClass().getName(), o.getClass().getSimpleName());
    }

    private void parse(Object o, DataNode n, String rule, String debug) throws Exception {
        Class<?> ClsO;
        if (o == null) {
            this.onError(debug + " is null.", n);
        }
        if (LinkedList.class == (ClsO = this.loadGenericClass(rule))) {
            this.parseVec((LinkedList)o, n, rule, debug);
        } else if (LinkedHashMap.class == ClsO || HashMap.class == ClsO) {
            this.parseMap((HashMap)o, n, rule, debug);
        } else {
            this.parseStruct(o, n, rule, debug);
        }
    }

    private void parseStruct(Object o, DataNode n, String rule, String debug) throws Exception {
        Class<?> ClsO = this.loadGenericClass(rule);
        if (!o.getClass().getName().equals(ClsO.getName())) {
            this.onError("Object does not matches this rule: " + rule, n);
        }
        int len = n.numChildren();
        for (int i = 0; i < len; ++i) {
            Object v;
            String ruleX;
            DataNode x = n.getChild(i);
            String key = x.getFieldName();
            if (key == null || key.length() <= 0 || key.equals("schemaLocation") || (ruleX = this.getRule(ClsO, key, n)) == null) continue;
            Class<?> ClsX = this.loadGenericClass(ruleX);
            if (DataMapper.isSimple(ClsX)) {
                v = this.parseGenericChild(x, ClsX, ruleX, debug);
                this.invokeSetter(v, key, o, x, debug);
                continue;
            }
            v = this.invokeGetter(key, o, x);
            if (v == null && ClsX != Vector.class) {
                v = ClsX.newInstance();
                this.invokeSetter(v, key, o, x, debug);
            }
            this.parse(v, x, ruleX, debug + '.' + key);
        }
    }

    private void parseVec(LinkedList<Object> list, DataNode n, String rule, String debug) throws Exception {
        String R = DataMapper.ruleRight(rule);
        if (R == null) {
            this.onError("Unexpected type: " + rule, n);
        }
        Class<?> Cls = this.loadGenericClass(R);
        int len = n.numChildren();
        for (int i = 0; i < len; ++i) {
            String d = debug + "[" + list.size() + "]";
            DataNode vn = n.getChild(i);
            if (ATTR_MAP_KEY.equals(vn.getFieldName())) continue;
            Object v = this.parseGenericChild(vn, Cls, R, d);
            list.add(v);
            if (!this.getVerbose().booleanValue()) continue;
            DataMapper.log(d + ": " + v);
        }
    }

    private void parseMap(Map<Object, Object> map, DataNode n, String rule, String debug) throws Exception {
        String R = DataMapper.ruleRight(rule);
        if (R == null) {
            this.onError("Unexpected type: " + rule, n);
            return;
        }
        String[] typeNames = R.split(GENERIC_SPLIT);
        if (typeNames.length != 2) {
            this.onError("Unexpected type: " + rule, n);
        }
        Class<?> ClsK = this.loadGenericClass(typeNames[0]);
        Class<?> ClsV = this.loadGenericClass(typeNames[1]);
        int len = n.numChildren();
        if (this.shortenMapEntry.booleanValue()) {
            for (int i = 0; i < len; ++i) {
                DataNode kn = null;
                DataNode vn = n.getChild(i);
                if (vn.numChildren() > 0) {
                    int size = vn.numChildren();
                    for (int j = 0; j < size; ++j) {
                        DataNode node = vn.getChild(j);
                        if (!ATTR_MAP_KEY.equals(node.getFieldName())) continue;
                        kn = node;
                        break;
                    }
                }
                if (kn == null) {
                    kn = DataNode.createString().setValue(vn.getFieldName());
                }
                Object k = this.parseGenericChildAny(kn, ClsK, typeNames[0], debug + ".k");
                Object v = this.parseGenericChildAny(vn, ClsV, typeNames[1], debug + ".v");
                map.put(k, v);
                if (!this.getVerbose().booleanValue()) continue;
                DataMapper.log(debug + "." + k + ": " + v);
            }
        } else {
            if ((1 & len) != 0) {
                this.onError("Invalid amount of children: " + len, n);
            }
            for (int i = 0; i < len; i += 2) {
                DataNode kn = n.getChild(i);
                DataNode vn = n.getChild(i + 1);
                Object k = this.parseGenericChildAny(kn, ClsK, typeNames[0], debug + ".k");
                Object v = this.parseGenericChildAny(vn, ClsV, typeNames[1], debug + ".v");
                map.put(k, v);
                if (!this.getVerbose().booleanValue()) continue;
                DataMapper.log(debug + "." + k + ": " + v);
            }
        }
    }

    private Object parseGenericChild(DataNode cn, Class<?> Cls, String rule, String debug) throws Exception {
        DataNode.TypeId id = cn.getTypeId();
        if (DataNode.TypeId.ANY.equals((Object)id)) {
            return this.parseGenericChildAny(cn, Cls, rule, debug);
        }
        switch (id) {
            case NULL: {
                return null;
            }
            case BOOL: {
                return cn.getValue();
            }
            case BIGINT: {
                return cn.getValue();
            }
            case STRING: {
                return this.parseGenericChildAny(cn, Cls, rule, debug);
            }
            case INT64: {
                return this.parseGenericChildAny(cn, Cls, rule, debug);
            }
            case DOUBLE: {
                return this.parseGenericChildAny(cn, Cls, rule, debug);
            }
            case OBJECT: 
            case ARRAY: {
                Object co = Cls.newInstance();
                this.parse(co, cn, rule, debug);
                return co;
            }
        }
        return null;
    }

    private Object parseGenericChildAny(DataNode cn, Class<?> Cls, String rule, String debug) throws Exception {
        if (Cls == Object.class) {
            return cn.getValue();
        }
        if (!DataMapper.isSimple(Cls)) {
            Object co = Cls.newInstance();
            this.parse(co, cn, rule, debug);
            return co;
        }
        Object o = cn.getValue();
        if (o == null) {
            if (cn.numChildren() == 1) {
                o = cn.getChild(0).getValue();
            } else if (cn.numChildren() > 1) {
                int len = cn.numChildren();
                for (int i = 0; i < len; ++i) {
                    DataNode node = cn.getChild(i);
                    String field = node.getFieldName();
                    if (!"v".equals(field) && !"val".equals(field) && !ATTR_VALUE.equals(field)) continue;
                    o = node.getValue();
                }
            }
        }
        if (o == null) {
            this.onError("No value for: " + debug);
        }
        return this.parseSimpleAny(o, Cls, cn, debug);
    }

    private Object parseSimpleAny(Object o, Class<?> Cls, DataNode cn, String debug) throws Exception {
        int radix = 10;
        if (o instanceof String) {
            String s = (String)o;
            if (s.length() <= 0) {
                return s;
            }
            if (Cls == Byte.class) {
                return Byte.valueOf(s, 10);
            }
            if (Cls == Short.class) {
                return Short.valueOf(s, 10);
            }
            if (Cls == Integer.class) {
                return Integer.valueOf(s, 10);
            }
            if (Cls == Long.class) {
                return Long.valueOf(s, 10);
            }
            if (Cls == BigInteger.class) {
                return new BigInteger(s, 10);
            }
            if (Cls == Float.class) {
                return Float.valueOf(s);
            }
            if (Cls == Double.class) {
                return Double.valueOf(s);
            }
            if (Cls == String.class) {
                return s;
            }
            if (Cls == Boolean.class) {
                return Boolean.valueOf(s.trim());
            }
            if (Cls.isEnum()) {
                char head = s.charAt(0);
                if (head == '-' || Character.isDigit(s.charAt(0))) {
                    Integer i = Integer.valueOf(s, 10);
                    return DataMapper.EnumFromInt(i, Cls);
                }
                return DataMapper.EnumFromString(s, Cls);
            }
            this.onError(debug);
            return null;
        }
        if (o instanceof Long) {
            Long v = (Long)o;
            if (Cls == Byte.class) {
                return v.byteValue();
            }
            if (Cls == Short.class) {
                return v.shortValue();
            }
            if (Cls == Integer.class) {
                return v.intValue();
            }
            if (Cls == Long.class) {
                return v;
            }
            if (Cls == BigInteger.class) {
                return BigInteger.valueOf(v);
            }
            if (Cls == Float.class) {
                return Float.valueOf(v.longValue());
            }
            if (Cls == Double.class) {
                return (double)v.longValue();
            }
            if (Cls == String.class) {
                return v.toString();
            }
            if (Cls == Boolean.class) {
                return v != 0L;
            }
            if (Cls.isEnum()) {
                return DataMapper.EnumFromInt(v.intValue(), Cls);
            }
            this.onError(debug, cn);
            return null;
        }
        if (o instanceof Double) {
            Double v = (Double)o;
            if (Cls == Byte.class) {
                return v.byteValue();
            }
            if (Cls == Short.class) {
                return v.shortValue();
            }
            if (Cls == Integer.class) {
                return v.intValue();
            }
            if (Cls == Long.class) {
                return v.longValue();
            }
            if (Cls == BigInteger.class) {
                return BigInteger.valueOf(v.longValue());
            }
            if (Cls == Float.class) {
                return Float.valueOf(v.floatValue());
            }
            if (Cls == Double.class) {
                return v;
            }
            if (Cls == String.class) {
                return v.toString();
            }
            if (Cls == Boolean.class) {
                return v != 0.0;
            }
            if (Cls.isEnum()) {
                return DataMapper.EnumFromInt(v.intValue(), Cls);
            }
            this.onError(debug, cn);
            return null;
        }
        if (o instanceof Boolean) {
            return o;
        }
        this.onError(debug);
        return null;
    }

    public String getPath() {
        return this.path;
    }

    public DataMapper setPath(String path) {
        this.path = path;
        return this;
    }

    private Boolean getVerbose() {
        return this.verbose;
    }

    public DataMapper setVerbose(Boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public DataMapper setShortenMapEntry(Boolean shortenMapEntry) {
        this.shortenMapEntry = shortenMapEntry;
        return this;
    }

    private Class<?> loadGenericClass(String rule) throws ClassNotFoundException {
        String name = DataMapper.ruleLeft(rule);
        return Class.forName(name.trim());
    }

    private Object invokeGetter(String key, Object o, Object node) throws Exception {
        String nameGetter;
        HashMap<String, Method> map = DataMapper.getGetters(o.getClass());
        Method method = map.get(key);
        if (method == null && (method = map.get(nameGetter = PREFIX_GETTER + DataMapper.upperHeadChar(key))) == null) {
            this.onError("No getter named \"" + nameGetter + "\" in " + o.getClass(), node);
            return null;
        }
        return method.invoke(o, new Object[0]);
    }

    private void onError(String hint) throws Exception {
        if (this.path != null && this.path.length() > 0) {
            hint = hint + "\n" + this.path;
        }
        throw new Exception("\n" + hint);
    }

    private void onError(String hint, Object n) {
        try {
            this.onError(hint, n, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void onError(String hint, Object n, boolean silent) throws Exception {
        if (silent) {
            return;
        }
        if (n != null) {
            hint = hint + "\n" + n;
        }
        if (this.path != null && this.path.length() > 0) {
            hint = hint + "\n" + this.path;
        }
        throw new Exception("\n" + hint);
    }

    private String getRule(Class<?> ClsO, String key, DataNode n) throws Exception {
        String nameGetter;
        HashMap<String, Method> map = DataMapper.getGetters(ClsO);
        Method method = map.get(key);
        if (method == null && (method = map.get(nameGetter = PREFIX_GETTER + DataMapper.upperHeadChar(key))) == null && !ATTR_MAP_KEY.equals(key)) {
            this.onError("No getter named '" + nameGetter + "' in " + ClsO, n);
        }
        if (method == null) {
            return null;
        }
        String rule = method.getGenericReturnType().toString();
        Type genericType = method.getGenericReturnType();
        if (genericType instanceof Class) {
            rule = ((Class)genericType).getName();
        } else if (genericType instanceof ParameterizedType) {
            rule = ((ParameterizedType)genericType).toString();
        }
        return rule;
    }

    private void invokeSetter(Object value, String key, Object o, DataNode n, String debug) throws Exception {
        String nameSetter;
        HashMap<String, Method> map = DataMapper.getSetters(o.getClass());
        Method method = map.get(key);
        if (method == null && (method = map.get(nameSetter = PREFIX_SETTER + DataMapper.upperHeadChar(key))) == null) {
            return;
        }
        if (this.getVerbose().booleanValue()) {
            DataMapper.log(debug + "." + key + ": " + value);
        }
        try {
            method.invoke(o, value);
        }
        catch (Exception e) {
            System.err.println(debug + "." + key);
            System.err.println(n);
            e.printStackTrace();
        }
    }

    private static HashMap<String, Method> getSetters(Class<?> ClsO) {
        HashMap<String, Method> methods = mapClassSetters.get(ClsO);
        if (methods == null) {
            Method[] meths = ClsO.getMethods();
            methods = new HashMap();
            for (Method method : meths) {
                if (!method.getName().startsWith(PREFIX_SETTER)) continue;
                methods.put(method.getName(), method);
            }
            mapClassSetters.put(ClsO, methods);
        }
        return methods;
    }

    private static HashMap<String, Method> getGetters(Class<?> ClsO) {
        HashMap<String, Method> methods = mapClassGetters.get(ClsO);
        if (methods == null) {
            Method[] meths = ClsO.getMethods();
            methods = new HashMap();
            for (Method method : meths) {
                if (!method.getName().startsWith(PREFIX_GETTER)) continue;
                methods.put(method.getName(), method);
            }
            mapClassGetters.put(ClsO, methods);
        }
        return methods;
    }

    private static String ruleLeft(String rule) {
        String name = rule;
        int index = rule.indexOf(GENERIC_LEFT);
        if (index >= 0) {
            name = rule.substring(0, index);
        }
        return name;
    }

    private static String ruleRight(String rule) {
        int iBegin = rule.indexOf(GENERIC_LEFT) + 1;
        int iEnd = rule.lastIndexOf(GENERIC_RIGHT);
        if (iBegin > 0 && iEnd > iBegin) {
            return rule.substring(iBegin, iEnd);
        }
        return null;
    }

    private static String upperHeadChar(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1, s.length());
    }

    private static <T extends Enum> Object EnumFromInt(int v, Class<T> clazz) {
        Method m = mapEnumGetters.get(clazz);
        if (m == null) {
            try {
                m = clazz.getMethod(ATTR_VALUE, new Class[0]);
                mapEnumGetters.put(clazz, m);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (Enum t : (Enum[])clazz.getEnumConstants()) {
            if (m != null) {
                Object i = null;
                try {
                    i = m.invoke((Object)t, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (i == null || !i.equals(v)) continue;
                return t;
            }
            if (t.ordinal() != v) continue;
            return t;
        }
        return null;
    }

    private static <T extends Enum> T EnumFromString(String v, Class<T> clazz) {
        for (Enum t : (Enum[])clazz.getEnumConstants()) {
            if (!t.name().equals(v.trim())) continue;
            return (T)t;
        }
        return null;
    }

    private static boolean isSimple(Class<?> C) {
        return C.isEnum() || C == String.class || C == Boolean.class || C == Float.class || C == Double.class || C == Byte.class || C == Short.class || C == Integer.class || C == Long.class || C == BigInteger.class;
    }

    private static void log(Object txt) {
        System.out.println("| " + txt);
    }
}

