/*
 * Decompiled with CFR 0.152.
 */
package invar.lib.data;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class DataNode<T> {
    public static final Charset UTF8 = Charset.forName("utf-8");
    private T value = null;
    private String fieldName;
    private TypeId typeId;
    private DataNode parent;
    private final List<DataNode> children = new ArrayList<DataNode>(32);

    private static <T> DataNode<T> create() {
        return new DataNode<T>();
    }

    static DataNode<Object> createNull() {
        return super.setTypeId(TypeId.NULL);
    }

    static DataNode createArray() {
        return super.setTypeId(TypeId.ARRAY);
    }

    static DataNode<Object> createObject() {
        return super.setTypeId(TypeId.OBJECT);
    }

    static DataNode<Object> createAny() {
        return super.setTypeId(TypeId.ANY);
    }

    static DataNode<String> createString() {
        return super.setTypeId(TypeId.STRING);
    }

    static DataNode<Boolean> createBoolean() {
        return super.setTypeId(TypeId.BOOL);
    }

    static DataNode<Long> createLong() {
        return super.setTypeId(TypeId.INT64);
    }

    static DataNode<BigInteger> createBigInt() {
        return super.setTypeId(TypeId.BIGINT);
    }

    static DataNode<Double> createDouble() {
        return super.setTypeId(TypeId.DOUBLE);
    }

    private DataNode() {
    }

    DataNode<T> setValue(T value) {
        this.value = value;
        return this;
    }

    DataNode<T> setFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    DataNode<T> addChild(DataNode node) {
        if (node == null) {
            return this;
        }
        node.setParent(this);
        this.children.add(node);
        return this;
    }

    private DataNode<T> setTypeId(TypeId typeId) {
        this.typeId = typeId;
        return this;
    }

    private DataNode<T> setParent(DataNode parent) {
        if (parent == this) {
            return this;
        }
        this.parent = parent;
        return this;
    }

    public int numChildren() {
        return this.children.size();
    }

    public DataNode getChild(int index) {
        return this.children.get(index);
    }

    public TypeId getTypeId() {
        return this.typeId;
    }

    public DataNode getParent() {
        return this.parent;
    }

    public T getValue() {
        return this.value;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(256);
        this.dump(s);
        return s.toString();
    }

    public void dump(StringBuilder s) {
        if (s == null) {
            return;
        }
        if (this.getFieldName() != null) {
            s.append(this.getFieldName());
            s.append('<');
            s.append(this.getTypeId().name());
            s.append('>');
            s.append(':');
        }
        if (TypeId.OBJECT.equals((Object)this.getTypeId())) {
            s.append('{');
            int len = this.children.size();
            for (int i = 0; i < len; ++i) {
                DataNode n = this.children.get(i);
                n.dump(s);
                if (i >= len - 1) continue;
                s.append(',');
            }
            s.append('}');
        } else if (TypeId.ARRAY.equals((Object)this.getTypeId())) {
            s.append('[');
            int len = this.children.size();
            for (int i = 0; i < len; ++i) {
                DataNode n = this.children.get(i);
                n.dump(s);
                if (i >= len - 1) continue;
                s.append(',');
            }
            s.append(']');
        } else {
            s.append(this.value);
        }
    }

    public static enum TypeId {
        INT64,
        BIGINT,
        DOUBLE,
        BOOL,
        STRING,
        NULL,
        OBJECT,
        ARRAY,
        ANY;

    }
}

