/*
 * Decompiled with CFR 0.152.
 */
package invar.lib.data;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import invar.lib.data.DataNode;
import invar.lib.data.DataParser;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class DataParserJson
implements DataParser {
    private final JsonFactory factory = new JsonFactory();

    @Override
    public DataNode parse(String content) throws IOException {
        DataNode root = DataNode.createObject();
        if (content == null || content.length() <= 0) {
            return root;
        }
        JsonParser parser = this.factory.createParser(content);
        this.initParser(parser);
        this.parse(parser, root);
        parser.close();
        return root.numChildren() > 0 ? root.getChild(0) : root;
    }

    @Override
    public DataNode parse(InputStream input) throws IOException {
        DataNode root = DataNode.createObject();
        if (input == null || input.available() <= 0) {
            return root;
        }
        JsonParser parser = this.factory.createParser(input);
        this.initParser(parser);
        this.parse(parser, root);
        parser.close();
        return root.numChildren() > 0 ? root.getChild(0) : root;
    }

    private void initParser(JsonParser parser) {
        parser.enable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        parser.enable(JsonParser.Feature.IGNORE_UNDEFINED);
        parser.enable(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS);
    }

    private void parse(JsonParser parser, DataNode root) throws IOException {
        String fieldName = null;
        DataNode<Object> parent = root;
        block15: while (!parser.isClosed()) {
            JsonToken token = parser.nextToken();
            if (token == null) continue;
            switch (token) {
                case START_ARRAY: {
                    DataNode dataNode = parent;
                    parent = DataNode.createArray().setFieldName(fieldName);
                    dataNode.addChild(parent);
                    fieldName = null;
                    continue block15;
                }
                case END_ARRAY: {
                    parent = parent.getParent();
                    fieldName = null;
                    continue block15;
                }
                case START_OBJECT: {
                    DataNode dataNode = parent;
                    parent = DataNode.createObject().setFieldName(fieldName);
                    dataNode.addChild(parent);
                    fieldName = null;
                    continue block15;
                }
                case END_OBJECT: {
                    parent = parent.getParent();
                    fieldName = null;
                    continue block15;
                }
                case VALUE_TRUE: {
                    parent.addChild(DataNode.createBoolean().setValue(true).setFieldName(fieldName));
                    fieldName = null;
                    continue block15;
                }
                case VALUE_FALSE: {
                    parent.addChild(DataNode.createBoolean().setValue(false).setFieldName(fieldName));
                    fieldName = null;
                    continue block15;
                }
                case VALUE_NULL: {
                    parent.addChild(DataNode.createNull().setValue(null).setFieldName(fieldName));
                    fieldName = null;
                    continue block15;
                }
                case VALUE_STRING: {
                    parent.addChild(DataNode.createString().setFieldName(fieldName).setValue(parser.getValueAsString()));
                    fieldName = null;
                    continue block15;
                }
                case VALUE_NUMBER_INT: {
                    try {
                        Long v = parser.getValueAsLong();
                        parent.addChild(DataNode.createLong().setFieldName(fieldName).setValue(v));
                    }
                    catch (JsonParseException e) {
                        BigInteger v = parser.getBigIntegerValue();
                        parent.addChild(DataNode.createBigInt().setFieldName(fieldName).setValue(v));
                    }
                    fieldName = null;
                    continue block15;
                }
                case VALUE_NUMBER_FLOAT: {
                    parent.addChild(DataNode.createDouble().setFieldName(fieldName).setValue(parser.getValueAsDouble()));
                    fieldName = null;
                    continue block15;
                }
                case FIELD_NAME: {
                    fieldName = parser.getValueAsString();
                    continue block15;
                }
            }
            fieldName = null;
        }
    }
}

