/*
 * Decompiled with CFR 0.152.
 */
package invar.lib.data;

import invar.lib.data.DataNode;
import invar.lib.data.DataParser;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Stack;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class DataParserXml
implements DataParser {
    private final XMLInputFactory factory;

    public DataParserXml() {
        XMLInputFactory fac = XMLInputFactory.newFactory();
        fac.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        fac.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        fac.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        fac.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        fac.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        fac.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
        this.factory = fac;
    }

    public DataParserXml(XMLInputFactory factory) {
        this.factory = factory;
    }

    @Override
    public DataNode parse(String content) throws Exception {
        DataNode<Object> root = DataNode.createObject();
        if (content == null || content.length() <= 0) {
            return root;
        }
        Stack<DataNode<Object>> stack = new Stack<DataNode<Object>>();
        XMLStreamReader reader = this.factory.createXMLStreamReader(new StringReader(content));
        return DataParserXml.StAX(root, reader, stack);
    }

    @Override
    public DataNode parse(InputStream input) throws Exception {
        DataNode<Object> root = DataNode.createObject();
        if (input == null || input.available() <= 0) {
            return root;
        }
        Stack<DataNode<Object>> stack = new Stack<DataNode<Object>>();
        XMLStreamReader reader = this.factory.createXMLStreamReader(input, DataNode.UTF8.name());
        return DataParserXml.StAX(root, reader, stack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataNode StAX(DataNode root, XMLStreamReader reader, Stack<DataNode<Object>> stack) throws XMLStreamException {
        try {
            while (reader.hasNext()) {
                int event = reader.getEventType();
                switch (event) {
                    case 1: {
                        DataParserXml.StAXStartElement(reader, stack);
                        break;
                    }
                    case 2: {
                        DataParserXml.StAXEndElement(reader, stack, root);
                        break;
                    }
                    case 4: {
                        DataParserXml.StAXCharacters(reader, stack);
                        break;
                    }
                    case 7: {
                        if (reader.getVersion() == null || reader.getVersion().equals("1.0")) break;
                        throw new XMLStreamException("XML version should be 1.0\n" + event + "\n");
                    }
                }
                reader.next();
            }
        }
        finally {
            reader.close();
        }
        return root.numChildren() > 0 ? root.getChild(0) : root;
    }

    private static void StAXCharacters(XMLStreamReader r, Stack<DataNode<Object>> stack) throws XMLStreamException {
        int length = r.getTextLength();
        char[] chars = new char[length];
        r.getTextCharacters(0, chars, 0, length);
        String value = String.valueOf(chars);
        DataNode<Object> n = stack.peek();
        if (stack.empty() || n == null) {
            throw new XMLStreamException("No DataNode to store value :" + value);
        }
        if (value.trim().length() <= 0 && n.getValue() != null) {
            return;
        }
        n.setValue(value);
    }

    private static void StAXStartElement(XMLStreamReader r, Stack<DataNode<Object>> stack) {
        int len = r.getAttributeCount();
        String name = r.getLocalName();
        if (len <= 0) {
            DataNode<Object> n = DataNode.createAny();
            n.setFieldName(name);
            stack.push(n);
        } else {
            DataNode<Object> n = DataNode.createAny();
            n.setFieldName(name);
            stack.push(n);
            for (int i = 0; i < len; ++i) {
                String k = r.getAttributeName(i).getLocalPart();
                String v = r.getAttributeValue(i);
                DataNode<Object> n1 = DataNode.createAny();
                n1.setFieldName(k);
                n1.setValue(v);
                n.addChild(n1);
            }
        }
    }

    private static void StAXEndElement(XMLStreamReader r, Stack<DataNode<Object>> stack, DataNode root) throws XMLStreamException {
        String name = r.getLocalName();
        DataNode<Object> n = stack.peek();
        if (stack.empty() || n == null) {
            throw new XMLStreamException("No start, but end: " + name);
        }
        if (!name.equals(n.getFieldName())) {
            throw new XMLStreamException("Redundant end element: " + name);
        }
        n = stack.pop();
        DataNode<Object> p = stack.empty() ? root : stack.peek();
        p.addChild(n);
    }
}

