/*
 * Decompiled with CFR 0.152.
 */
package invar.lib.data;

import invar.lib.InvarEnum;
import invar.lib.InvarRule;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Deprecated
public final class InvarReadData {
    public static String charset = "utf-8";
    public static Boolean verbose = false;
    public static HashMap<String, Class<?>> aliasBasics = null;
    public static HashMap<String, Class<?>> aliasEnums = null;
    public static HashMap<String, Class<?>> aliasStructs = null;
    private static String suffix;
    public static boolean shortenMapEntry;
    private String path;
    private static final String GENERIC_LEFT = "<";
    private static final String GENERIC_RIGHT = ">";
    private static final String GENERIC_SPLIT = ",";
    private static final String PREFIX_SETTER = "set";
    private static final String PREFIX_GETTER = "get";
    private static final String ATTR_MAP_KEY = "key";
    private static final String ATTR_VALUE = "value";
    private static final HashMap<Class<?>, HashMap<String, Method>> mapClassSetters;
    private static final HashMap<Class<?>, HashMap<String, Method>> mapClassGetters;

    public static void start(Object root, String path, String suffix) throws Exception {
        InvarReadData.suffix = suffix;
        File file = new File(path);
        if (!file.exists()) {
            throw new IOException("Path doesn't exist:\n" + file.getAbsolutePath());
        }
        if (aliasBasics == null) {
            throw new Exception("InvarReadData.aliasBasics is null");
        }
        if (aliasEnums == null) {
            throw new Exception("InvarReadData.aliasEnums is null");
        }
        if (aliasStructs == null) {
            throw new Exception("InvarReadData.aliasStructs is null");
        }
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File f = new File(dir, name);
                if (f.isDirectory() && !f.getName().startsWith(".")) {
                    return true;
                }
                return name.endsWith(suffix);
            }
        };
        ArrayList<File> files = new ArrayList<File>();
        InvarReadData.recursiveReadFile(files, file, filter);
        block0: for (File f : files) {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(f);
            if (!doc.hasChildNodes()) {
                return;
            }
            InvarReadData.log("Read <- " + f.getAbsolutePath());
            NodeList children = doc.getChildNodes();
            int len = children.getLength();
            for (int i = 0; i < len; ++i) {
                Node x = children.item(i);
                if (1 != x.getNodeType()) continue;
                new InvarReadData(f.getAbsolutePath()).parse(root, x);
                continue block0;
            }
        }
    }

    public static void parse(Object o, String xml) throws Exception {
        if (null == xml || 0 == xml.length()) {
            return;
        }
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes(charset)));
        if (!doc.hasChildNodes()) {
            return;
        }
        NodeList children = doc.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node x = children.item(i);
            if (1 != x.getNodeType()) continue;
            new InvarReadData("").parsePart(o, x);
            break;
        }
    }

    public static void parseFull(Object root, String xml) throws Exception {
        if (null == xml || 0 == xml.length()) {
            return;
        }
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes(charset)));
        if (!doc.hasChildNodes()) {
            return;
        }
        NodeList children = doc.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node x = children.item(i);
            if (1 != x.getNodeType()) continue;
            new InvarReadData("NotFile").parse(root, x);
            break;
        }
    }

    public InvarReadData(String path) {
        this.path = path;
    }

    public InvarReadData() {
        this.path = "";
    }

    public <T> void parse(T root, InputStream input) throws Exception {
        if (null == input) {
            return;
        }
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(input);
        if (!doc.hasChildNodes()) {
            return;
        }
        NodeList children = doc.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node x = children.item(i);
            if (1 != x.getNodeType()) continue;
            this.parse(root, x);
            break;
        }
    }

    public void parse(Object o, Node n) throws Exception {
        this.path = n.getBaseURI();
        this.parse(o, n, o.getClass().getName(), "");
    }

    private void parsePart(Object host, Node n) throws Exception {
        String key = n.getNodeName();
        String rule = this.getRule(host.getClass(), key, n);
        Object o = this.invokeGetter(key, host, n);
        this.parse(o, n, rule, key);
    }

    private void parse(Object o, Node n, String rule, String debug) throws Exception {
        Class<?> ClsO;
        if (o == null) {
            this.onError(debug + " is null.", n);
        }
        if (LinkedList.class == (ClsO = this.loadGenericClass(rule))) {
            this.parseVec((LinkedList)o, n, rule, debug);
        } else if (LinkedHashMap.class == ClsO) {
            this.parseMap((HashMap)o, n, rule, debug);
        } else {
            this.parseStruct(o, n, rule, debug);
        }
    }

    private void parseStruct(Object o, Node n, String rule, String debug) throws Exception {
        NamedNodeMap attrs;
        Class<?> ClsO = this.loadGenericClass(rule);
        if (o.getClass().getName() != ClsO.getName()) {
            this.onError("Object does not matches this rule: " + rule, n);
        }
        if ((attrs = n.getAttributes()) == null) {
            this.onError("Node unavailable: " + rule, n);
            return;
        }
        int attrsLen = attrs.getLength();
        for (int i = 0; i < attrsLen; ++i) {
            String ruleX;
            Node x = attrs.item(i);
            String key = x.getNodeName();
            if (key.indexOf(":") >= 0 || (ruleX = this.getRule(ClsO, key, n)) == null) continue;
            Class<?> ClsX = this.loadGenericClass(ruleX);
            String vStr = x.getNodeValue();
            Object v = this.parseSimple(ClsX, vStr, ruleX, debug + '.' + key, n);
            this.invokeSetter(v, key, o, n);
        }
        NodeList children = n.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            String key;
            String ruleX;
            Node x = children.item(i);
            if (1 != x.getNodeType() || (ruleX = this.getRule(ClsO, key = x.getNodeName(), n)) == null) continue;
            Class<?> ClsX = this.loadGenericClass(ruleX);
            String vStr = null;
            Object v = null;
            if (InvarReadData.isSimpleType(ClsX)) {
                vStr = this.getAttr(x, ATTR_VALUE);
                v = this.parseSimple(ClsX, vStr, ruleX, debug + '.' + key, x);
                this.invokeSetter(v, key, o, x);
                continue;
            }
            v = this.invokeGetter(key, o, x);
            if (v == null && ClsX != Vector.class) {
                v = ClsX.newInstance();
                this.invokeSetter(v, key, o, x);
            }
            this.parse(v, x, ruleX, debug + '.' + key);
        }
    }

    private void parseVec(LinkedList<Object> list, Node n, String rule, String debug) throws Exception {
        String R = InvarReadData.ruleRight(rule);
        if (R == null) {
            this.onError("Unexpected type: " + rule, n);
        }
        Class<?> Cls = this.loadGenericClass(R);
        NodeList children = n.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node vn = children.item(i);
            if (1 != vn.getNodeType()) continue;
            Object v = this.parseGenericChild(vn, Cls, R, debug + "[" + list.size() + "]");
            list.add(v);
        }
    }

    private void parseMap(HashMap<Object, Object> map, Node n, String rule, String debug) throws Exception {
        String[] typeNames;
        String R = InvarReadData.ruleRight(rule);
        if (R == null) {
            this.onError("Unexpected type: " + rule.toString(), n);
        }
        if ((typeNames = R.split(GENERIC_SPLIT)).length != 2) {
            this.onError("Unexpected type: " + rule.toString(), n);
        }
        Class<?> ClsK = this.loadGenericClass(typeNames[0]);
        Class<?> ClsV = this.loadGenericClass(typeNames[1]);
        List<Node> children = InvarReadData.elementNodes(n);
        int len = children.size();
        if (InvarReadData.isSimpleType(ClsK) && shortenMapEntry) {
            for (Node vn : children) {
                String s = InvarReadData.getAttrOptional(vn, ATTR_MAP_KEY);
                if (s == null || s.length() <= 0) continue;
                Object k = this.parseSimple(ClsK, s, typeNames[0], debug + ".k", vn);
                Object v = this.parseGenericChild(vn, ClsV, typeNames[1], debug + ".v");
                map.put(k, v);
            }
        } else {
            if ((1 & len) != 0) {
                this.onError("Invalid amount of children: " + len, n);
            }
            for (int i = 0; i < len; i += 2) {
                Node kn = children.get(i);
                Node vn = children.get(i + 1);
                Object k = this.parseGenericChild(kn, ClsK, typeNames[0], debug + ".k");
                Object v = this.parseGenericChild(vn, ClsV, typeNames[1], debug + ".v");
                map.put(k, v);
            }
        }
    }

    private Object parseGenericChild(Node cn, Class<?> Cls, String rule, String debug) throws Exception {
        if (InvarReadData.isSimpleType(Cls)) {
            return this.parseSimple(Cls, this.getAttr(cn, ATTR_VALUE), rule, debug, cn);
        }
        Object co = Cls.newInstance();
        this.parse(co, cn, rule, debug);
        return co;
    }

    private Object parseSimple(Class<?> vType, String s, String rule, String debug, Node x) throws Exception {
        if (rule.equals("int8")) {
            this.checkNumber(s, -128L, 127L, debug, x);
        } else if (rule.equals("int16")) {
            this.checkNumber(s, -32768L, 32767L, debug, x);
        } else if (rule.equals("int32")) {
            this.checkNumber(s, (Long)Integer.MIN_VALUE, (Long)Integer.MAX_VALUE, debug, x);
        } else if (rule.equals("uint8")) {
            this.checkNumber(s, 0L, 255L, debug, x);
        } else if (rule.equals("uint16")) {
            this.checkNumber(s, 0L, 65535L, debug, x);
        } else if (rule.equals("uint32")) {
            this.checkNumber(s, 0L, 0xFFFFFFFFL, debug, x);
        }
        Object arg = null;
        if (String.class == vType) {
            arg = s;
        } else if (Byte.class == vType) {
            arg = Byte.decode(s);
        } else if (Short.class == vType) {
            arg = Short.decode(s);
        } else if (Integer.class == vType) {
            arg = Integer.decode(s);
        } else if (Long.class == vType) {
            arg = Long.decode(s);
        } else if (Float.class == vType) {
            arg = Float.valueOf(s);
        } else if (Double.class == vType) {
            arg = Double.valueOf(s);
        } else if (Boolean.class == vType) {
            arg = Boolean.valueOf(s);
        } else if (aliasEnums.containsValue(vType)) {
            arg = InvarReadData.parseEnumObject(vType, s);
            if (arg == null) {
                this.onError("Enum value is invalid.", x);
            }
        } else {
            this.onError("Not a simple value.", x);
        }
        if (verbose.booleanValue()) {
            StringBuilder code = new StringBuilder();
            code.append(InvarReadData.fixedLen(40, debug));
            code.append(" : ");
            code.append(InvarReadData.fixedLen(32, rule));
            code.append(" : ");
            code.append(arg);
            InvarReadData.log(code);
        }
        return arg;
    }

    private void checkNumber(String s, Long min, Long max, String debug, Node x) throws Exception {
        Long v = Long.decode(s);
        if (v < min || v > max) {
            this.onError(debug + " = " + v + ". Number is out of range [" + min + ", " + max + "]", x);
        }
    }

    private static Object parseEnumObject(Class<?> type, String s) throws Exception {
        Method[] mets;
        Object o = null;
        o = InvarReadData.EnumFromString(s, type);
        if (o != null) {
            return o;
        }
        Integer v = Integer.parseInt(s);
        for (Method m : mets = type.getMethods()) {
            if (!m.getName().equals("valueOf")) continue;
            o = m.invoke(type, v);
            break;
        }
        return o;
    }

    private String getAttr(Node n, String name) throws Exception {
        String v = InvarReadData.getAttrOptional(n, name);
        if (v.equals("")) {
            this.onError("Attribute '" + name + "' is required.", n);
        }
        return v;
    }

    private String getRule(Class<?> ClsO, String key, Node n) throws Exception {
        String nameGetter;
        HashMap<String, Method> map = InvarReadData.getGetters(ClsO);
        Method method = map.get(key);
        if (method == null && (method = map.get(nameGetter = PREFIX_GETTER + InvarReadData.upperHeadChar(key))) == null && key != ATTR_MAP_KEY) {
            this.onError("No getter named '" + nameGetter + "' in " + ClsO, n);
        }
        if (method == null) {
            return null;
        }
        String rule = method.getGenericReturnType().toString();
        InvarRule anno = method.getAnnotation(InvarRule.class);
        if (anno != null) {
            rule = anno.T();
        }
        return rule;
    }

    private Object invokeGetter(String key, Object o, Node x) throws Exception {
        String nameGetter;
        HashMap<String, Method> map = InvarReadData.getGetters(o.getClass());
        Method method = map.get(key);
        if (method == null && (method = map.get(nameGetter = PREFIX_GETTER + InvarReadData.upperHeadChar(key))) == null) {
            this.onError("No getter named \"" + nameGetter + "\" in " + o.getClass(), x);
            return null;
        }
        return method.invoke(o, new Object[0]);
    }

    private void invokeSetter(Object value, String key, Object o, Node n) throws Exception {
        String nameSetter;
        HashMap<String, Method> map = InvarReadData.getSetters(o.getClass());
        Method method = map.get(key);
        if (method == null && (method = map.get(nameSetter = PREFIX_SETTER + InvarReadData.upperHeadChar(key))) == null) {
            this.onError("No setter named \"" + nameSetter + "()\" in " + o.getClass(), n);
            return;
        }
        method.invoke(o, value);
    }

    private Class<?> loadGenericClass(String rule) throws Exception {
        String name = InvarReadData.ruleLeft(rule);
        Class<?> Cls = InvarReadData.getClassByAlias(name);
        if (Cls == null) {
            Cls = Class.forName(name);
        }
        if (Cls == null) {
            this.onError("No Class matches this rule: " + rule, null);
        }
        return Cls;
    }

    private void onError(String hint, Node n) throws Exception {
        throw new Exception("\n" + hint + "\n" + InvarReadData.formatXmlNode(n) + "\n" + this.path);
    }

    private static boolean isSimpleType(Class<?> vType) {
        if (String.class == vType) {
            return true;
        }
        if (Boolean.class == vType) {
            return true;
        }
        if (Byte.class == vType) {
            return true;
        }
        if (Short.class == vType) {
            return true;
        }
        if (Integer.class == vType) {
            return true;
        }
        if (Long.class == vType) {
            return true;
        }
        if (Float.class == vType) {
            return true;
        }
        if (Double.class == vType) {
            return true;
        }
        return aliasEnums.containsValue(vType);
    }

    private static HashMap<String, Method> getSetters(Class<?> ClsO) {
        HashMap<String, Method> methods = mapClassSetters.get(ClsO);
        if (methods == null) {
            Method[] meths = ClsO.getMethods();
            methods = new HashMap();
            for (Method method : meths) {
                if (!method.getName().startsWith(PREFIX_SETTER)) continue;
                methods.put(method.getName(), method);
                InvarRule anno = method.getAnnotation(InvarRule.class);
                if (anno == null) continue;
                String shortName = anno.S();
                methods.put(shortName, method);
            }
            mapClassSetters.put(ClsO, methods);
        }
        return methods;
    }

    private static HashMap<String, Method> getGetters(Class<?> ClsO) {
        HashMap<String, Method> methods = mapClassGetters.get(ClsO);
        if (methods == null) {
            Method[] meths = ClsO.getMethods();
            methods = new HashMap();
            for (Method method : meths) {
                if (!method.getName().startsWith(PREFIX_GETTER)) continue;
                methods.put(method.getName(), method);
                InvarRule anno = method.getAnnotation(InvarRule.class);
                if (anno == null) continue;
                String shortName = anno.S();
                methods.put(shortName, method);
            }
            mapClassGetters.put(ClsO, methods);
        }
        return methods;
    }

    private static String ruleLeft(String rule) {
        String name = rule;
        if (rule.indexOf(GENERIC_LEFT) >= 0) {
            name = rule.substring(0, rule.indexOf(GENERIC_LEFT));
        }
        return name;
    }

    private static String ruleRight(String rule) {
        int iBegin = rule.indexOf(GENERIC_LEFT) + 1;
        int iEnd = rule.lastIndexOf(GENERIC_RIGHT);
        if (iBegin > 0 && iEnd > iBegin) {
            return rule.substring(iBegin, iEnd);
        }
        return null;
    }

    private static Class<?> getClassByAlias(String name) {
        Class<?> ClsN = aliasBasics.get(name);
        if (ClsN == null) {
            ClsN = aliasEnums.get(name);
        }
        if (ClsN == null) {
            ClsN = aliasStructs.get(name);
        }
        return ClsN;
    }

    private static String getAttrOptional(Node node, String name) {
        String v = "";
        NamedNodeMap attrs = node.getAttributes();
        if (attrs == null) {
            return v;
        }
        Node n = attrs.getNamedItem(name);
        if (n != null) {
            v = n.getNodeValue();
        }
        return v;
    }

    private static List<Node> elementNodes(Node n) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList children = n.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node cn = children.item(i);
            if (1 != cn.getNodeType()) continue;
            nodes.add(cn);
        }
        return nodes;
    }

    private static String formatXmlNode(Node n) {
        NamedNodeMap attrs = n.getAttributes();
        StringBuilder code = new StringBuilder();
        code.append(GENERIC_LEFT + n.getNodeName());
        int len = attrs != null ? attrs.getLength() : 0;
        for (int i = 0; i < len; ++i) {
            Node a = attrs.item(i);
            code.append(" " + a.toString());
        }
        code.append(" />");
        return code.toString();
    }

    private static String upperHeadChar(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1, s.length());
    }

    private static String fixedLen(Integer len, String str) {
        String blank = " ";
        int delta = len - str.length();
        if (delta > 0) {
            for (int i = 0; i < delta; ++i) {
                str = str + blank;
            }
        }
        return str;
    }

    private static void log(Object txt) {
        System.out.println(txt);
    }

    private static void recursiveReadFile(List<File> all, File file, FilenameFilter filter) {
        if (all.size() > 1024) {
            return;
        }
        if (file.isFile()) {
            all.add(file);
        } else if (file.isDirectory()) {
            File[] files = file.listFiles(filter);
            for (int i = 0; i < files.length; ++i) {
                InvarReadData.recursiveReadFile(all, files[i], filter);
            }
        }
    }

    public static <T extends InvarEnum> T EnumFromInt(Integer v, Class<T> clazz) {
        for (InvarEnum t : (InvarEnum[])clazz.getEnumConstants()) {
            if (!t.value().equals(v)) continue;
            return (T)t;
        }
        return null;
    }

    public static <T extends InvarEnum> T EnumFromString(String v, Class<T> clazz) {
        for (InvarEnum t : (InvarEnum[])clazz.getEnumConstants()) {
            if (!t.name().equals(v)) continue;
            return (T)t;
        }
        return null;
    }

    static {
        shortenMapEntry = true;
        mapClassSetters = new HashMap();
        mapClassGetters = new HashMap();
    }
}

