/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.stvconsultants.easygloss;

import com.stvconsultants.easygloss.footnotes.Footnote;

/**
 * A <code>StandardGloss</code> is a decorator for annotated objects.
 * 
 * @author Stephen Connolly
 */
public class StandardBooleanGloss extends AbstractGloss {
    
    private final Footnote annotation;
    private final boolean value;
    
    /**
     * Creates a new instance of StandardGloss
     * 
     * @param annotation The type of annotation that this gloss will stick to
     * @param value The value to inject
     */
    public StandardBooleanGloss(Footnote annotation, boolean value) {
        this.annotation = annotation;
        this.value = value;
    }
    
    /**
     * Apply the gloss to the instance
     * @param instance The object to which the gloss should be applied
     */
    public void apply(Object instance) {
        apply(annotation, instance, value);        
    }

    /**
     * Apply the gloss to the class
     * @param instanceClass The object to which the gloss should be applied
     */
    public void applyStatic(Class instanceClass) {
        applyStatic(annotation, instanceClass, value);
    }

}
