/*
 * Decompiled with CFR 0.152.
 */
package com.stvconsultants.easygloss.footnotes;

import com.stvconsultants.easygloss.footnotes.FootnoteElement;
import java.lang.annotation.Annotation;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Footnote {
    private final Annotation annotation;
    private final Class<? extends Annotation> annotationType;
    private final HashMap<String, FootnoteElement> criterion;

    public Footnote(Class<? extends Annotation> annotationType) {
        this.annotation = null;
        this.annotationType = annotationType;
        this.criterion = new HashMap();
    }

    public Footnote(Annotation annotation) {
        this.annotation = annotation;
        this.annotationType = annotation.annotationType();
        this.criterion = new HashMap();
    }

    public Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    public boolean equals(Object value) {
        boolean retVal;
        if (this == value) {
            retVal = true;
        } else if (value == null) {
            retVal = false;
        } else if (value.getClass() == this.getClass()) {
            Footnote that = (Footnote)value;
            retVal = (this.annotation == that.annotation || this.annotation != null && ((Object)this.annotation).equals(that.annotation)) && (this.annotationType == that.annotationType || this.annotationType != null && this.annotationType.equals(that.annotationType)) && (this.criterion == that.criterion || this.criterion != null && this.criterion.equals(that.criterion));
        } else {
            retVal = false;
        }
        return retVal;
    }

    public boolean matches(Annotation that) {
        boolean retVal;
        if (that == null) {
            retVal = false;
        } else if (!that.annotationType().equals(this.annotationType)) {
            retVal = false;
        } else if (this.annotation != null) {
            retVal = ((Object)this.annotation).equals(that);
        } else {
            retVal = true;
            for (FootnoteElement criteria : this.criterion.values()) {
                if (criteria.compare(that)) continue;
                retVal = false;
                break;
            }
        }
        return retVal;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.annotation == null ? 0 : ((Object)this.annotation).hashCode());
        hash = 31 * hash + this.annotationType.hashCode();
        hash = 31 * hash + this.criterion.hashCode();
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.getClass().getName());
        buf.append("(");
        if (this.annotation != null) {
            buf.append(this.annotation);
            buf.append(",");
        }
        buf.append("@");
        buf.append(this.annotationType.getName());
        buf.append("(");
        boolean first = true;
        for (FootnoteElement ele : this.criterion.values()) {
            if (first) {
                first = false;
            } else {
                buf.append(",");
            }
            buf.append(ele.toString());
        }
        buf.append("))");
        return buf.toString();
    }

    public Footnote with(String name, Object value) {
        boolean add;
        FootnoteElement ele;
        if (this.criterion.containsKey(name)) {
            ele = this.criterion.get(name);
            add = false;
        } else {
            ele = new FootnoteElement(name);
            add = true;
        }
        ele.setEquals(value);
        if (add) {
            this.criterion.put(ele.getName(), ele);
        }
        return this;
    }

    public Footnote without(String name, Object value) {
        boolean add;
        FootnoteElement ele;
        if (this.criterion.containsKey(name)) {
            ele = this.criterion.get(name);
            add = false;
        } else {
            ele = new FootnoteElement(name);
            add = true;
        }
        ele.addNotEqual(value);
        if (add) {
            this.criterion.put(ele.getName(), ele);
        }
        return this;
    }

    public Footnote including(String name, Object value) {
        boolean add;
        FootnoteElement ele;
        if (this.criterion.containsKey(name)) {
            ele = this.criterion.get(name);
            add = false;
        } else {
            ele = new FootnoteElement(name);
            add = true;
        }
        ele.addContains(value);
        if (add) {
            this.criterion.put(ele.getName(), ele);
        }
        return this;
    }

    public Footnote excluding(String name, Object value) {
        boolean add;
        FootnoteElement ele;
        if (this.criterion.containsKey(name)) {
            ele = this.criterion.get(name);
            add = false;
        } else {
            ele = new FootnoteElement(name);
            add = true;
        }
        ele.addExcludes(value);
        if (add) {
            this.criterion.put(ele.getName(), ele);
        }
        return this;
    }

    public Footnote matching(String name, String regex) {
        boolean add;
        FootnoteElement ele;
        if (this.criterion.containsKey(name)) {
            ele = this.criterion.get(name);
            add = false;
        } else {
            ele = new FootnoteElement(name);
            add = true;
        }
        ele.setRegex(regex);
        if (add) {
            this.criterion.put(ele.getName(), ele);
        }
        return this;
    }
}

