/*
 * Decompiled with CFR 0.152.
 */
package com.stvconsultants.easygloss.footnotes;

import com.stvconsultants.easygloss.footnotes.IllegalFootnoteMatchingRuleError;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FootnoteElement {
    private final String name;
    Object mustEqual = null;
    List<Object> mustNotEqual = null;
    List<Object> mustContain = null;
    List<Object> mustExclude = null;
    String regex = null;

    public FootnoteElement(String name) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        this.name = name;
    }

    public void setEquals(Object target) {
        if (target != null && (this.mustContain != null || this.mustNotEqual != null || this.mustExclude != null)) {
            throw new IllegalFootnoteMatchingRuleError();
        }
        this.mustEqual = target;
    }

    public void addNotEqual(Object target) {
        if (target != null && this.mustEqual != null) {
            throw new IllegalFootnoteMatchingRuleError();
        }
        if (this.mustNotEqual == null) {
            this.mustNotEqual = new ArrayList<Object>();
        }
        this.mustNotEqual.add(target);
    }

    public void addContains(Object target) {
        if (target != null && this.mustEqual != null) {
            throw new IllegalFootnoteMatchingRuleError();
        }
        if (this.mustContain == null) {
            this.mustContain = new ArrayList<Object>();
        }
        this.mustContain.add(target);
    }

    public void addExcludes(Object target) {
        if (target != null && this.mustEqual != null) {
            throw new IllegalFootnoteMatchingRuleError();
        }
        if (this.mustExclude == null) {
            this.mustExclude = new ArrayList<Object>();
        }
        this.mustExclude.add(target);
    }

    public void setRegex(String regex) {
        if (regex != null && this.mustEqual != null) {
            throw new IllegalFootnoteMatchingRuleError();
        }
        this.regex = regex;
    }

    public boolean compare(Annotation annotation) {
        Class<? extends Annotation> clazz = annotation.annotationType();
        boolean retVal = true;
        try {
            Method method = clazz.getMethod(this.getName(), new Class[0]);
            Object value = method.invoke((Object)annotation, new Object[0]);
            if (this.mustEqual != null) {
                retVal = this.mustEqual.equals(value);
            }
            if (retVal && this.mustNotEqual != null) {
                boolean bl = retVal = !this.mustNotEqual.contains(value);
            }
            if (retVal && this.regex != null) {
                String valueStr = (String)value;
                retVal = valueStr.matches(this.regex);
            }
            if (retVal && (value instanceof Collection || value instanceof Object[])) {
                List<Object> valueCollection;
                List<Object> list = valueCollection = value instanceof Collection ? (List<Object>)value : Arrays.asList((Object[])value);
                if (retVal && this.mustExclude != null) {
                    retVal = FootnoteElement.nullIntersection(this.mustExclude, valueCollection);
                }
                if (retVal && this.mustContain != null) {
                    retVal = valueCollection.containsAll(this.mustContain);
                }
            }
        }
        catch (NoSuchMethodException e) {
            retVal = false;
        }
        catch (InvocationTargetException e) {
            retVal = false;
        }
        catch (IllegalAccessException e) {
            retVal = false;
        }
        return retVal;
    }

    private static boolean nullIntersection(Collection<?> a, Collection<?> b) {
        boolean retVal = true;
        for (Object element : a) {
            if (!b.contains(element)) continue;
            retVal = false;
            break;
        }
        return retVal;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getName());
        if (this.mustEqual != null) {
            buf.append("=");
            if (this.mustEqual instanceof String) {
                buf.append("\"");
            }
            buf.append(this.mustEqual);
            if (this.mustEqual instanceof String) {
                buf.append("\"");
            }
        } else {
            boolean f;
            if (this.regex != null) {
                buf.append(" like \"");
                buf.append(this.regex);
                buf.append("\"");
            } else {
                buf.append("=*");
            }
            if (this.mustNotEqual != null) {
                buf.append(" not in [");
                f = true;
                for (Object item : this.mustNotEqual) {
                    if (!f) {
                        buf.append(",");
                    }
                    if (item instanceof String) {
                        buf.append("\"");
                    }
                    buf.append(item);
                    if (item instanceof String) {
                        buf.append("\"");
                    }
                    f = false;
                }
                buf.append("]");
            }
            if (this.mustContain != null) {
                buf.append(" with elements [");
                f = true;
                for (Object item : this.mustContain) {
                    if (!f) {
                        buf.append(",");
                    }
                    if (item instanceof String) {
                        buf.append("\"");
                    }
                    buf.append(item);
                    if (item instanceof String) {
                        buf.append("\"");
                    }
                    f = false;
                }
                buf.append("]");
            }
            if (this.mustExclude != null) {
                buf.append(" without elements [");
                f = true;
                for (Object item : this.mustExclude) {
                    if (!f) {
                        buf.append(",");
                    }
                    if (item instanceof String) {
                        buf.append("\"");
                    }
                    buf.append(item);
                    if (item instanceof String) {
                        buf.append("\"");
                    }
                    f = false;
                }
                buf.append("]");
            }
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        boolean retVal;
        if (this == obj) {
            retVal = true;
        } else if (obj == null || obj.getClass() != this.getClass()) {
            retVal = false;
        } else {
            FootnoteElement that = (FootnoteElement)obj;
            retVal = (this.name == that.name || this.name.equals(that.name)) && (this.mustEqual == that.mustEqual || this.mustEqual != null && this.mustEqual.equals(that.mustEqual)) && (this.mustNotEqual == that.mustNotEqual || this.mustNotEqual != null && ((Object)this.mustNotEqual).equals(that.mustNotEqual)) && (this.mustContain == that.mustContain || this.mustContain != null && ((Object)this.mustContain).equals(that.mustContain)) && (this.mustExclude == that.mustExclude || this.mustExclude != null && ((Object)this.mustExclude).equals(that.mustExclude)) && (this.regex == that.regex || this.regex != null && this.regex.equals(that.regex));
        }
        return retVal;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.name.hashCode();
        hash = 31 * hash + (this.mustEqual == null ? 0 : this.mustEqual.hashCode());
        hash = 31 * hash + (this.mustNotEqual == null ? 0 : ((Object)this.mustNotEqual).hashCode());
        hash = 31 * hash + (this.mustContain == null ? 0 : ((Object)this.mustContain).hashCode());
        hash = 31 * hash + (this.mustContain == null ? 0 : ((Object)this.mustContain).hashCode());
        hash = 31 * hash + (this.regex == null ? 0 : this.regex.hashCode());
        return hash;
    }
}

