/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.stvconsultants.easygloss;

/**
 * A <code>GlossApplicationError</code> indicates that something went wrong during application of the gloss.
 *
 * @author Stephen Connolly
 */
public class GlossApplicationError extends java.lang.Error {

    /**
     * Creates a new instance of <code>GlossApplicationError</code> without detail message.
     */
    public GlossApplicationError() {
    }

    /**
     * Constructs an instance of <code>GlossApplicationError</code> with the specified detail message.
     *
     * @param msg the detail message.
     */
    public GlossApplicationError(String msg) {
        super(msg);
    }

    /**
     * Constructs an instance of <code>GlossApplicationError</code> with the specified cause.
     *
     * @param e the cause of the error.
     */
    public GlossApplicationError(Throwable e) {
        super(e);
    }

    /**
     * Constructs an instance of <code>GlossApplicationError</code> with the specified cause.
     *
     * @param msg the detail message.
     * @param e the cause of the error.
     */
    public GlossApplicationError(String msg, Throwable e) {
        super(msg, e);
    }

}
