/*
 * Copyright 2006 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.stvconsultants.easygloss.javaee;

import com.sun.faces.spi.InjectionProvider;
import com.sun.faces.spi.InjectionProviderException;

/**
 * An implementation of Java Server Faces 1.2 InjectionProvider in order to support testing JSF applications.
 *
 * @author STV Consultants
 */
public class GlossInjectionProvider implements InjectionProvider {

    private static JavaEEGloss gloss;

    public GlossInjectionProvider() {
        gloss = null;
    }

    /**
     * <p>The implementation of this method must perform the following steps: <ul> <li>Inject the supported resources
     * per the Servlet 2.5 specification into the provided object</li> <li>Inoke any method marked with the
     * <code>@PostConstruct</code> annotation (per the Common Annotations Specification)</li> </ul> </p>
     *
     * @param managedBean the target managed bean
     *
     * @throws InjectionProviderException if an error occurs during resource injection
     */
    public synchronized void inject(Object managedBean) throws InjectionProviderException {
        if (gloss != null) {
            gloss.apply(managedBean);
        }
    }

    /**
     * <p>The implemenation of this method must invoke any method marked with the <code>@PreDestroy</code> annotation
     * (per the Common Annotations Specification).
     *
     * @param managedBean the target managed bean
     *
     * @throws InjectionProviderException if an error occurs when invoking the method annotated by the
     *                                    <code>@PreDestroy</code> annotation
     */
    public synchronized void invokePreDestroy(Object managedBean) throws InjectionProviderException {
        if (gloss != null) {
            gloss.beforeDestroy(managedBean);
        }
    }

    /**
     * Removes all gloss from injection.
     */
    public static synchronized void clearInjection() {
        gloss = null;
    }

    /**
     * Sets a new gloss to apply.
     *
     * @param gloss the new gloss to apply.
     */
    public static synchronized void setInjection(JavaEEGloss gloss) {
        GlossInjectionProvider.gloss = gloss;
    }

}