/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.base;

import java.util.concurrent.ConcurrentHashMap;

public class DurianPlugins {
    private static DurianPlugins INSTANCE = new DurianPlugins();
    private final ConcurrentHashMap<Class<?>, Object> map = new ConcurrentHashMap();
    public static final String PROPERTY_PREFIX = "durian.plugins.";

    static void resetForTesting() {
        INSTANCE = new DurianPlugins();
    }

    private DurianPlugins() {
    }

    public static <T> void register(Class<T> pluginClass, T pluginImpl) throws IllegalStateException {
        INSTANCE.registerInternal(pluginClass, pluginImpl);
    }

    private <T> void registerInternal(Class<T> pluginClass, T pluginImpl) throws IllegalStateException {
        assert (pluginClass.isInstance(pluginImpl));
        Object existingValue = this.map.putIfAbsent(pluginClass, pluginImpl);
        if (existingValue != null) {
            throw new IllegalStateException("Another " + pluginClass + " was already registered: " + existingValue);
        }
    }

    public static <T> T get(Class<T> pluginClass, T defaultImpl) {
        return INSTANCE.getInternal(pluginClass, defaultImpl);
    }

    private <T> T getInternal(Class<T> pluginClass, T defaultImpl) {
        assert (pluginClass.isInstance(defaultImpl));
        return (T)this.map.computeIfAbsent(pluginClass, clazz -> {
            Object impl = DurianPlugins.getPluginImplementationViaProperty(clazz);
            return impl != null ? impl : defaultImpl;
        });
    }

    private static Object getPluginImplementationViaProperty(Class<?> pluginClass) {
        String className = pluginClass.getCanonicalName();
        if (className == null) {
            throw new IllegalArgumentException("Class " + pluginClass + " does not have a canonical name!");
        }
        String implementingClass = System.getProperty(PROPERTY_PREFIX + className);
        if (implementingClass != null) {
            try {
                Class<?> cls = Class.forName(implementingClass);
                cls = cls.asSubclass(pluginClass);
                return cls.newInstance();
            }
            catch (ClassCastException e) {
                throw new RuntimeException(className + " implementation is not an instance of " + className + ": " + implementingClass);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(className + " implementation class not found: " + implementingClass, e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(className + " implementation not able to be instantiated: " + implementingClass, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(className + " implementation not able to be accessed: " + implementingClass, e);
            }
        }
        return null;
    }
}

