/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.base;

import com.diffplug.common.base.Predicates;
import com.diffplug.common.base.StringPrinter;
import com.diffplug.common.base.Throwing;
import com.diffplug.common.base.Unhandled;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class FieldsAndGetters {
    public static Stream<Map.Entry<Field, Object>> fields(Object obj) {
        return FieldsAndGetters.fields(obj, Predicates.alwaysTrue());
    }

    public static Stream<Map.Entry<Field, Object>> fields(Object obj, Predicate<Field> predicate) {
        Class clazz = obj == null ? ObjectIsNull.class : obj.getClass();
        return Arrays.asList(clazz.getFields()).stream().filter(field -> Modifier.isPublic(field.getModifiers())).filter(field -> !Modifier.isStatic(field.getModifiers())).filter(predicate).map(field -> FieldsAndGetters.createEntry(field, FieldsAndGetters.tryCall(field.getName(), () -> field.get(obj))));
    }

    public static Stream<Map.Entry<Method, Object>> getters(Object obj) {
        return FieldsAndGetters.getters(obj, Predicates.alwaysTrue());
    }

    public static Stream<Map.Entry<Method, Object>> getters(Object obj, Predicate<Method> predicate) {
        Class clazz = obj == null ? ObjectIsNull.class : obj.getClass();
        return Arrays.asList(clazz.getMethods()).stream().filter(method -> method.getParameterTypes().length == 0).filter(method -> Modifier.isPublic(method.getModifiers())).filter(method -> !Modifier.isStatic(method.getModifiers())).filter(method -> !method.getReturnType().equals(Void.TYPE)).filter(predicate).map(method -> FieldsAndGetters.createEntry(method, FieldsAndGetters.tryCall(method.getName(), () -> method.invoke(obj, new Object[0]))));
    }

    private static Object tryCall(String methodName, Throwing.Supplier<Object> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable error) {
            return new CallException(methodName, error);
        }
    }

    public static Stream<Map.Entry<String, Object>> fieldsAndGetters(Object obj) {
        return FieldsAndGetters.fieldsAndGetters(obj, Predicates.alwaysTrue());
    }

    public static Stream<Map.Entry<String, Object>> fieldsAndGetters(Object obj, Predicate<String> predicate) {
        Stream<Map.Entry> fields = FieldsAndGetters.fields(obj, field -> predicate.test(field.getName())).map(entry -> FieldsAndGetters.createEntry(((Field)entry.getKey()).getName(), entry.getValue()));
        Function<Method, String> methodName = method -> method.getName() + "()";
        Stream<Map.Entry> getters = FieldsAndGetters.getters(obj, field -> predicate.test((String)methodName.apply((Method)field))).map(entry -> FieldsAndGetters.createEntry(methodName.apply((Method)entry.getKey()), entry.getValue()));
        return Stream.concat(fields, getters);
    }

    public static void dumpIf(String name, Object obj, Predicate<String> evalPredicate, Predicate<Map.Entry<String, Object>> dumpPredicate, StringPrinter printer) {
        printer.println(name + ": " + obj.getClass().getName());
        FieldsAndGetters.fieldsAndGetters(obj, evalPredicate).filter(dumpPredicate).forEach(entry -> printer.println("\t" + (String)entry.getKey() + " = " + entry.getValue()));
    }

    public static void dumpAll(String name, Object obj) {
        FieldsAndGetters.dumpAll(name, obj, StringPrinter.systemOut());
    }

    public static void dumpNonNull(String name, Object obj) {
        FieldsAndGetters.dumpNonNull(name, obj, StringPrinter.systemOut());
    }

    public static void dumpAll(String name, Object obj, StringPrinter printer) {
        FieldsAndGetters.dumpIf(name, obj, Predicates.alwaysTrue(), Predicates.alwaysTrue(), printer);
    }

    public static void dumpNonNull(String name, Object obj, StringPrinter printer) {
        FieldsAndGetters.dumpIf(name, obj, Predicates.alwaysTrue(), entry -> entry.getValue() != null, printer);
    }

    private static <K, V> Map.Entry<K, V> createEntry(final K key, final V value) {
        return new Map.Entry<K, V>(){

            @Override
            public K getKey() {
                return key;
            }

            @Override
            public V getValue() {
                return value;
            }

            @Override
            public V setValue(V value2) {
                throw Unhandled.operationException();
            }
        };
    }

    private static class CallException
    extends Exception {
        private static final long serialVersionUID = 1206955156719866328L;
        private final String methodName;

        private CallException(String methodName, Throwable cause) {
            super(cause);
            this.methodName = methodName;
        }

        @Override
        public String toString() {
            return "When calling " + this.methodName + ": " + this.getCause().getMessage();
        }
    }

    public static class ObjectIsNull {
    }
}

