/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.base;

import com.diffplug.common.base.StringPrinter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class StackDumper {
    static StringPrinter pristineSysErr = new StringPrinter(System.err::print);

    public static void dump(String message, List<StackTraceElement> stack) {
        StackDumper.printEmphasized(message + "\n" + StackDumper.stackTraceToString(stack));
    }

    public static void dump(String message, StackTraceElement[] stackTrace) {
        StackDumper.dump(message, Arrays.asList(stackTrace));
    }

    public static void dump(String message, Throwable exception) {
        StackDumper.printEmphasized(StringPrinter.buildString(printer -> {
            printer.println(message);
            exception.printStackTrace(printer.toPrintWriter());
        }));
    }

    public static void dump(String message) {
        StackDumper.dump(message, StackDumper.captureStackBelow(new Class[0]));
    }

    public static void dump(String message, int stackLimit, String ... classPrefixesToExclude) {
        Predicate<StackTraceElement> isIncluded = trace -> {
            for (String prefix : classPrefixesToExclude) {
                if (!trace.getClassName().startsWith(prefix)) continue;
                return false;
            }
            return true;
        };
        List<StackTraceElement> stack = StackDumper.captureStackBelow(new Class[0]).stream().filter(trace -> trace.getLineNumber() >= 0).filter(isIncluded).limit(stackLimit).collect(Collectors.toList());
        StackDumper.dump(message, stack);
    }

    public static void dumpWhenSysOutContains(String trigger) {
        System.setOut(StackDumper.wrapAndDumpWhenContains(System.out, trigger));
    }

    public static void dumpWhenSysErrContains(String trigger) {
        System.setErr(StackDumper.wrapAndDumpWhenContains(System.err, trigger));
    }

    public static PrintStream wrapAndDumpWhenContains(PrintStream source, String trigger) {
        StringPrinter wrapped = new StringPrinter(StringPrinter.stringsToLines(perLine -> {
            source.println((String)perLine);
            if (perLine.contains(trigger)) {
                StackDumper.dump("Triggered by " + trigger);
            }
        }));
        return wrapped.toPrintStream();
    }

    private static String stackTraceToString(List<StackTraceElement> stack) {
        return StringPrinter.buildString(printer -> {
            for (StackTraceElement element : stack) {
                printer.print("at ");
                printer.print(element.getClassName());
                printer.print(".");
                printer.print(element.getMethodName());
                printer.print("(");
                printer.print(element.getFileName());
                printer.print(":");
                printer.print(Integer.toString(element.getLineNumber()));
                printer.println(")");
            }
        });
    }

    public static List<StackTraceElement> captureStackBelow(Class<?> ... clazzes) {
        ArrayList toIgnore = new ArrayList(clazzes.length + 1);
        toIgnore.addAll(Arrays.asList(clazzes));
        toIgnore.add(StackDumper.class);
        Predicate<StackTraceElement> isSkipped = element -> toIgnore.stream().anyMatch(clazz -> {
            String name = element.getClassName();
            return name.equals(clazz.getName()) || name.startsWith(clazz.getName() + "$$Lambda");
        });
        List<StackTraceElement> rawStack = Arrays.asList(Thread.currentThread().getStackTrace());
        ListIterator<StackTraceElement> iterator = rawStack.listIterator();
        while (iterator.hasNext() && !isSkipped.test(iterator.next())) {
        }
        boolean foundSomethingToSkip = iterator.hasNext();
        if (foundSomethingToSkip) {
            while (iterator.hasNext() && isSkipped.test(iterator.next())) {
            }
            return rawStack.subList(iterator.previousIndex(), rawStack.size());
        }
        return rawStack;
    }

    private static void printEmphasized(String toPrint) {
        pristineSysErr.println("+----------\\");
        for (String line : toPrint.split("\n")) {
            pristineSysErr.println("| " + line);
        }
        pristineSysErr.println("+----------/");
    }
}

