/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.base;

import com.diffplug.common.base.Errors;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@FunctionalInterface
public interface TreeDef<T> {
    public List<T> childrenOf(T var1);

    default public TreeDef<T> filter(Predicate<T> predicate) {
        return TreeDef.of(node -> TreeDef.filteredList(this.childrenOf(node), predicate));
    }

    public static <T> TreeDef<T> of(final Function<T, List<T>> childFunc) {
        return new TreeDef<T>(){

            @Override
            public List<T> childrenOf(T node) {
                return (List)childFunc.apply(node);
            }
        };
    }

    public static <T> List<T> filteredList(List<T> unfiltered, Predicate<T> filter) {
        return unfiltered.stream().filter(filter).collect(Collectors.toList());
    }

    public static Parented<File> forFile(Consumer<Throwable> errorPolicy) {
        Errors.Handling errors = Errors.createHandling(errorPolicy);
        return Parented.of(file -> errors.getWithDefault(() -> {
            if (file.isDirectory()) {
                return Arrays.asList(file.listFiles());
            }
            return Collections.emptyList();
        }, Collections.emptyList()), file -> errors.getWithDefault(() -> file.getParentFile(), null));
    }

    public static Parented<Path> forPath(Consumer<Throwable> errorPolicy) {
        Errors.Handling errors = Errors.createHandling(errorPolicy);
        return Parented.of(path -> errors.getWithDefault(() -> {
            if (Files.isDirectory(path, new LinkOption[0])) {
                return Files.list(path).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }, Collections.emptyList()), path -> errors.getWithDefault(() -> path.getParent(), null));
    }

    public static interface Parented<T>
    extends TreeDef<T> {
        public T parentOf(T var1);

        @Override
        default public Parented<T> filter(Predicate<T> predicate) {
            return Parented.of(node -> TreeDef.filteredList(this.childrenOf(node), predicate), node -> {
                if (predicate.test(node)) {
                    return this.parentOf(node);
                }
                return null;
            });
        }

        public static <T> Parented<T> of(final Function<T, List<T>> childFunc, final Function<T, T> parentFunc) {
            return new Parented<T>(){

                @Override
                public List<T> childrenOf(T node) {
                    return (List)childFunc.apply(node);
                }

                @Override
                public T parentOf(T node) {
                    return parentFunc.apply(node);
                }
            };
        }
    }
}

