/*
 * Decompiled with CFR 0.152.
 */
package com.sudicode.githubextensions;

import com.google.gson.JsonParser;
import com.sudicode.githubextensions.global.Environment;
import com.sudicode.githubextensions.service.PayloadHandler;
import java.security.MessageDigest;
import org.apache.commons.codec.digest.HmacUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/github-webhook"})
public class WebhookController {
    private static final Logger LOG = LoggerFactory.getLogger(WebhookController.class);
    private static final int SIGNATURE_LENGTH = 45;
    private final PayloadHandler payloadHandler;
    private final JsonParser jsonParser;

    @Autowired
    public WebhookController(PayloadHandler payloadHandler, JsonParser jsonParser) {
        this.payloadHandler = payloadHandler;
        this.jsonParser = jsonParser;
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<HttpStatus> postRequest(@RequestHeader(value="X-Hub-Signature") String signature, @RequestBody String payload) {
        boolean invalidLength;
        if (signature == null) {
            return new ResponseEntity<HttpStatus>(HttpStatus.BAD_REQUEST);
        }
        String computed = String.format("sha1=%s", HmacUtils.hmacSha1Hex(Environment.SECRET_TOKEN, payload));
        boolean bl = invalidLength = signature.length() != 45;
        if (invalidLength || !MessageDigest.isEqual(signature.getBytes(), computed.getBytes())) {
            return new ResponseEntity<HttpStatus>(HttpStatus.UNAUTHORIZED);
        }
        try {
            this.payloadHandler.handle(this.jsonParser.parse(payload).getAsJsonObject());
        }
        catch (Throwable e) {
            LOG.error(e.getMessage(), e);
            return new ResponseEntity<HttpStatus>(HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity<HttpStatus>(HttpStatus.NO_CONTENT);
    }
}

