/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.session;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.autoconfigure.session.HashMapSessionConfiguration;
import org.springframework.boot.autoconfigure.session.HazelcastSessionConfiguration;
import org.springframework.boot.autoconfigure.session.JdbcSessionConfiguration;
import org.springframework.boot.autoconfigure.session.MongoSessionConfiguration;
import org.springframework.boot.autoconfigure.session.NoOpSessionConfiguration;
import org.springframework.boot.autoconfigure.session.RedisSessionConfiguration;
import org.springframework.boot.autoconfigure.session.StoreType;
import org.springframework.util.Assert;

final class SessionStoreMappings {
    private static final Map<StoreType, Class<?>> MAPPINGS;

    private SessionStoreMappings() {
    }

    public static String getConfigurationClass(StoreType sessionStoreType) {
        Class<?> configurationClass = MAPPINGS.get((Object)sessionStoreType);
        Assert.state(configurationClass != null, "Unknown session store type " + (Object)((Object)sessionStoreType));
        return configurationClass.getName();
    }

    public static StoreType getType(String configurationClassName) {
        for (Map.Entry<StoreType, Class<?>> entry : MAPPINGS.entrySet()) {
            if (!entry.getValue().getName().equals(configurationClassName)) continue;
            return entry.getKey();
        }
        throw new IllegalStateException("Unknown configuration class " + configurationClassName);
    }

    static {
        HashMap<StoreType, Class> mappings = new HashMap<StoreType, Class>();
        mappings.put(StoreType.REDIS, RedisSessionConfiguration.class);
        mappings.put(StoreType.MONGO, MongoSessionConfiguration.class);
        mappings.put(StoreType.JDBC, JdbcSessionConfiguration.class);
        mappings.put(StoreType.HAZELCAST, HazelcastSessionConfiguration.class);
        mappings.put(StoreType.HASH_MAP, HashMapSessionConfiguration.class);
        mappings.put(StoreType.NONE, NoOpSessionConfiguration.class);
        MAPPINGS = Collections.unmodifiableMap(mappings);
    }
}

