/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.UnsatisfiedServletRequestParameterException;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.AbstractHandlerMethodMapping;
import org.springframework.web.servlet.mvc.condition.NameValueExpression;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMethodMappingNamingStrategy;
import org.springframework.web.util.WebUtils;

public abstract class RequestMappingInfoHandlerMapping
extends AbstractHandlerMethodMapping<RequestMappingInfo> {
    private static final Method HTTP_OPTIONS_HANDLE_METHOD;

    protected RequestMappingInfoHandlerMapping() {
        this.setHandlerMethodMappingNamingStrategy(new RequestMappingInfoHandlerMethodMappingNamingStrategy());
    }

    @Override
    protected Set<String> getMappingPathPatterns(RequestMappingInfo info) {
        return info.getPatternsCondition().getPatterns();
    }

    @Override
    protected RequestMappingInfo getMatchingMapping(RequestMappingInfo info, HttpServletRequest request) {
        return info.getMatchingCondition(request);
    }

    @Override
    protected Comparator<RequestMappingInfo> getMappingComparator(final HttpServletRequest request) {
        return new Comparator<RequestMappingInfo>(){

            @Override
            public int compare(RequestMappingInfo info1, RequestMappingInfo info2) {
                return info1.compareTo(info2, request);
            }
        };
    }

    @Override
    protected void handleMatch(RequestMappingInfo info, String lookupPath, HttpServletRequest request) {
        Map<Object, Object> decodedUriVariables;
        Map<String, String> uriVariables;
        String bestPattern;
        super.handleMatch(info, lookupPath, request);
        Set<String> patterns = info.getPatternsCondition().getPatterns();
        if (patterns.isEmpty()) {
            bestPattern = lookupPath;
            uriVariables = Collections.emptyMap();
            decodedUriVariables = Collections.emptyMap();
        } else {
            bestPattern = patterns.iterator().next();
            uriVariables = this.getPathMatcher().extractUriTemplateVariables(bestPattern, lookupPath);
            decodedUriVariables = this.getUrlPathHelper().decodePathVariables(request, uriVariables);
        }
        request.setAttribute(BEST_MATCHING_PATTERN_ATTRIBUTE, bestPattern);
        request.setAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, decodedUriVariables);
        if (this.isMatrixVariableContentAvailable()) {
            Map<String, MultiValueMap<String, String>> matrixVars = this.extractMatrixVariables(request, uriVariables);
            request.setAttribute(HandlerMapping.MATRIX_VARIABLES_ATTRIBUTE, matrixVars);
        }
        if (!info.getProducesCondition().getProducibleMediaTypes().isEmpty()) {
            Set<MediaType> mediaTypes = info.getProducesCondition().getProducibleMediaTypes();
            request.setAttribute(PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE, mediaTypes);
        }
    }

    private boolean isMatrixVariableContentAvailable() {
        return !this.getUrlPathHelper().shouldRemoveSemicolonContent();
    }

    private Map<String, MultiValueMap<String, String>> extractMatrixVariables(HttpServletRequest request, Map<String, String> uriVariables) {
        LinkedHashMap<String, MultiValueMap<String, String>> result = new LinkedHashMap<String, MultiValueMap<String, String>>();
        for (Map.Entry<String, String> uriVar : uriVariables.entrySet()) {
            String matrixVariables;
            String uriVarValue = uriVar.getValue();
            int equalsIndex = uriVarValue.indexOf(61);
            if (equalsIndex == -1) continue;
            int semicolonIndex = uriVarValue.indexOf(59);
            if (semicolonIndex == -1 || semicolonIndex == 0 || equalsIndex < semicolonIndex) {
                matrixVariables = uriVarValue;
            } else {
                matrixVariables = uriVarValue.substring(semicolonIndex + 1);
                uriVariables.put(uriVar.getKey(), uriVarValue.substring(0, semicolonIndex));
            }
            MultiValueMap<String, String> vars = WebUtils.parseMatrixVariables(matrixVariables);
            result.put(uriVar.getKey(), this.getUrlPathHelper().decodeMatrixVariables(request, vars));
        }
        return result;
    }

    @Override
    protected HandlerMethod handleNoMatch(Set<RequestMappingInfo> infos, String lookupPath, HttpServletRequest request) throws ServletException {
        PartialMatchHelper helper = new PartialMatchHelper(infos, request);
        if (helper.isEmpty()) {
            return null;
        }
        if (helper.hasMethodsMismatch()) {
            Set<String> methods = helper.getAllowedMethods();
            if (HttpMethod.OPTIONS.matches(request.getMethod())) {
                HttpOptionsHandler handler = new HttpOptionsHandler(methods);
                return new HandlerMethod(handler, HTTP_OPTIONS_HANDLE_METHOD);
            }
            throw new HttpRequestMethodNotSupportedException(request.getMethod(), methods);
        }
        if (helper.hasConsumesMismatch()) {
            Set<MediaType> mediaTypes = helper.getConsumableMediaTypes();
            MediaType contentType = null;
            if (StringUtils.hasLength(request.getContentType())) {
                try {
                    contentType = MediaType.parseMediaType(request.getContentType());
                }
                catch (InvalidMediaTypeException ex) {
                    throw new HttpMediaTypeNotSupportedException(ex.getMessage());
                }
            }
            throw new HttpMediaTypeNotSupportedException(contentType, new ArrayList<MediaType>(mediaTypes));
        }
        if (helper.hasProducesMismatch()) {
            Set<MediaType> mediaTypes = helper.getProducibleMediaTypes();
            throw new HttpMediaTypeNotAcceptableException(new ArrayList<MediaType>(mediaTypes));
        }
        if (helper.hasParamsMismatch()) {
            List<String[]> conditions = helper.getParamConditions();
            throw new UnsatisfiedServletRequestParameterException(conditions, request.getParameterMap());
        }
        return null;
    }

    static {
        try {
            HTTP_OPTIONS_HANDLE_METHOD = HttpOptionsHandler.class.getMethod("handle", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("Failed to retrieve internal handler method for HTTP OPTIONS", ex);
        }
    }

    private static class HttpOptionsHandler {
        private final HttpHeaders headers = new HttpHeaders();

        public HttpOptionsHandler(Set<String> declaredMethods) {
            this.headers.setAllow(HttpOptionsHandler.initAllowedHttpMethods(declaredMethods));
        }

        private static Set<HttpMethod> initAllowedHttpMethods(Set<String> declaredMethods) {
            LinkedHashSet<HttpMethod> result = new LinkedHashSet<HttpMethod>(declaredMethods.size());
            if (declaredMethods.isEmpty()) {
                for (HttpMethod method : HttpMethod.values()) {
                    if (HttpMethod.TRACE.equals((Object)method)) continue;
                    result.add(method);
                }
            } else {
                boolean hasHead = declaredMethods.contains("HEAD");
                for (String method : declaredMethods) {
                    result.add(HttpMethod.valueOf(method));
                    if (hasHead || !"GET".equals(method)) continue;
                    result.add(HttpMethod.HEAD);
                }
            }
            return result;
        }

        public HttpHeaders handle() {
            return this.headers;
        }
    }

    private static class PartialMatchHelper {
        private final List<PartialMatch> partialMatches = new ArrayList<PartialMatch>();

        public PartialMatchHelper(Set<RequestMappingInfo> infos, HttpServletRequest request) {
            for (RequestMappingInfo info : infos) {
                if (info.getPatternsCondition().getMatchingCondition(request) == null) continue;
                this.partialMatches.add(new PartialMatch(info, request));
            }
        }

        public boolean isEmpty() {
            return this.partialMatches.isEmpty();
        }

        public boolean hasMethodsMismatch() {
            for (PartialMatch match : this.partialMatches) {
                if (!match.hasMethodsMatch()) continue;
                return false;
            }
            return true;
        }

        public boolean hasConsumesMismatch() {
            for (PartialMatch match : this.partialMatches) {
                if (!match.hasConsumesMatch()) continue;
                return false;
            }
            return true;
        }

        public boolean hasProducesMismatch() {
            for (PartialMatch match : this.partialMatches) {
                if (!match.hasProducesMatch()) continue;
                return false;
            }
            return true;
        }

        public boolean hasParamsMismatch() {
            for (PartialMatch match : this.partialMatches) {
                if (!match.hasParamsMatch()) continue;
                return false;
            }
            return true;
        }

        public Set<String> getAllowedMethods() {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            for (PartialMatch match : this.partialMatches) {
                for (RequestMethod method : match.getInfo().getMethodsCondition().getMethods()) {
                    result.add(method.name());
                }
            }
            return result;
        }

        public Set<MediaType> getConsumableMediaTypes() {
            LinkedHashSet<MediaType> result = new LinkedHashSet<MediaType>();
            for (PartialMatch match : this.partialMatches) {
                if (!match.hasMethodsMatch()) continue;
                result.addAll(match.getInfo().getConsumesCondition().getConsumableMediaTypes());
            }
            return result;
        }

        public Set<MediaType> getProducibleMediaTypes() {
            LinkedHashSet<MediaType> result = new LinkedHashSet<MediaType>();
            for (PartialMatch match : this.partialMatches) {
                if (!match.hasConsumesMatch()) continue;
                result.addAll(match.getInfo().getProducesCondition().getProducibleMediaTypes());
            }
            return result;
        }

        public List<String[]> getParamConditions() {
            ArrayList<String[]> result = new ArrayList<String[]>();
            for (PartialMatch match : this.partialMatches) {
                Set<NameValueExpression<String>> set;
                if (!match.hasProducesMatch() || CollectionUtils.isEmpty(set = match.getInfo().getParamsCondition().getExpressions())) continue;
                int i = 0;
                String[] array = new String[set.size()];
                for (NameValueExpression<String> expression : set) {
                    array[i++] = expression.toString();
                }
                result.add(array);
            }
            return result;
        }

        private static class PartialMatch {
            private final RequestMappingInfo info;
            private final boolean methodsMatch;
            private final boolean consumesMatch;
            private final boolean producesMatch;
            private final boolean paramsMatch;

            public PartialMatch(RequestMappingInfo info, HttpServletRequest request) {
                this.info = info;
                this.methodsMatch = info.getMethodsCondition().getMatchingCondition(request) != null;
                this.consumesMatch = info.getConsumesCondition().getMatchingCondition(request) != null;
                this.producesMatch = info.getProducesCondition().getMatchingCondition(request) != null;
                this.paramsMatch = info.getParamsCondition().getMatchingCondition(request) != null;
            }

            public RequestMappingInfo getInfo() {
                return this.info;
            }

            public boolean hasMethodsMatch() {
                return this.methodsMatch;
            }

            public boolean hasConsumesMatch() {
                return this.hasMethodsMatch() && this.consumesMatch;
            }

            public boolean hasProducesMatch() {
                return this.hasConsumesMatch() && this.producesMatch;
            }

            public boolean hasParamsMatch() {
                return this.hasProducesMatch() && this.paramsMatch;
            }

            public String toString() {
                return this.info.toString();
            }
        }
    }
}

