/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import com.sumologic.http.aggregation.SumoBufferFlusher;
import com.sumologic.http.queue.BufferWithEviction;
import com.sumologic.http.queue.BufferWithFifoEviction;
import com.sumologic.http.queue.CostBoundedConcurrentQueue;
import com.sumologic.http.sender.ProxySettings;
import com.sumologic.http.sender.SumoHttpSender;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SumoLogicAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private LayoutWrappingEncoder<ILoggingEvent> encoder = null;
    private String url = null;
    private String proxyHost = null;
    private int proxyPort = -1;
    private String proxyAuth = null;
    private String proxyUser = null;
    private String proxyPassword = null;
    private String proxyDomain = null;
    private int connectionTimeoutMs = 1000;
    private int socketTimeoutMs = 60000;
    private int retryIntervalMs = 10000;
    private boolean flushAllBeforeStopping = true;
    private long messagesPerRequest = 100L;
    private long maxFlushIntervalMs = 10000L;
    private long flushingAccuracyMs = 250L;
    private String sourceName = null;
    private String sourceHost = null;
    private String sourceCategory = null;
    private long maxQueueSizeBytes = 1000000L;
    private String retryableHttpCodeRegex = "^5.*";
    private SumoHttpSender sender;
    private SumoBufferFlusher flusher;
    private volatile BufferWithEviction<String> queue;
    private static final String CLIENT_NAME = "logback-appender";

    public LayoutWrappingEncoder<ILoggingEvent> getEncoder() {
        return this.encoder;
    }

    public void setEncoder(LayoutWrappingEncoder<ILoggingEvent> encoder) {
        this.encoder = encoder;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public long getMaxQueueSizeBytes() {
        return this.maxQueueSizeBytes;
    }

    public void setMaxQueueSizeBytes(long maxQueueSizeBytes) {
        this.maxQueueSizeBytes = maxQueueSizeBytes;
    }

    public long getMessagesPerRequest() {
        return this.messagesPerRequest;
    }

    public void setMessagesPerRequest(long messagesPerRequest) {
        this.messagesPerRequest = messagesPerRequest;
    }

    public long getMaxFlushIntervalMs() {
        return this.maxFlushIntervalMs;
    }

    public void setMaxFlushIntervalMs(long maxFlushIntervalMs) {
        this.maxFlushIntervalMs = maxFlushIntervalMs;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public String getSourceHost() {
        return this.sourceHost;
    }

    public void setSourceHost(String sourceHost) {
        this.sourceHost = sourceHost;
    }

    public String getSourceCategory() {
        return this.sourceCategory;
    }

    public void setSourceCategory(String sourceCategory) {
        this.sourceCategory = sourceCategory;
    }

    public long getFlushingAccuracyMs() {
        return this.flushingAccuracyMs;
    }

    public void setFlushingAccuracyMs(long flushingAccuracyMs) {
        this.flushingAccuracyMs = flushingAccuracyMs;
    }

    public int getConnectionTimeoutMs() {
        return this.connectionTimeoutMs;
    }

    public void setConnectionTimeoutMs(int connectionTimeoutMs) {
        this.connectionTimeoutMs = connectionTimeoutMs;
    }

    public int getSocketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    public void setSocketTimeoutMs(int socketTimeoutMs) {
        this.socketTimeoutMs = socketTimeoutMs;
    }

    public int getRetryIntervalMs() {
        return this.retryIntervalMs;
    }

    public void setRetryIntervalMs(int retryIntervalMs) {
        this.retryIntervalMs = retryIntervalMs;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyAuth() {
        return this.proxyAuth;
    }

    public void setProxyAuth(String proxyAuth) {
        this.proxyAuth = proxyAuth;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getProxyDomain() {
        return this.proxyDomain;
    }

    public void setProxyDomain(String proxyDomain) {
        this.proxyDomain = proxyDomain;
    }

    public boolean getFlushAllBeforeStopping() {
        return this.flushAllBeforeStopping;
    }

    public void setFlushAllBeforeStopping(boolean flushAllBeforeStopping) {
        this.flushAllBeforeStopping = flushAllBeforeStopping;
    }

    public void setRetryableHttpCodeRegex(String retryableHttpCodeRegex) {
        this.retryableHttpCodeRegex = retryableHttpCodeRegex;
    }

    public String getRetryableHttpCodeRegex() {
        return this.retryableHttpCodeRegex;
    }

    public void start() {
        int errors = 0;
        if (this.encoder == null) {
            this.addStatus((Status)new ErrorStatus("No encoder set for the appender named \"" + this.name + "\".", (Object)this));
            ++errors;
        }
        if (this.url == null) {
            this.addStatus((Status)new ErrorStatus("No url set for the appender named \"" + this.name + "\".", (Object)this));
            ++errors;
        }
        if (errors > 0) {
            return;
        }
        super.start();
        this.logger.debug("Starting appender");
        if (this.queue == null) {
            this.queue = new BufferWithFifoEviction(this.maxQueueSizeBytes, (CostBoundedConcurrentQueue.CostAssigner)new CostBoundedConcurrentQueue.CostAssigner<String>(){

                public long cost(String e) {
                    return e.length();
                }
            });
        } else {
            this.queue.setCapacity(this.maxQueueSizeBytes);
        }
        if (this.sender == null) {
            this.sender = new SumoHttpSender();
        }
        this.sender.setRetryIntervalMs((long)this.retryIntervalMs);
        this.sender.setConnectionTimeoutMs(this.connectionTimeoutMs);
        this.sender.setSocketTimeoutMs(this.socketTimeoutMs);
        this.sender.setUrl(this.url);
        this.sender.setSourceHost(this.sourceHost);
        this.sender.setSourceName(this.sourceName);
        this.sender.setSourceCategory(this.sourceCategory);
        this.sender.setProxySettings(new ProxySettings(this.proxyHost, Integer.valueOf(this.proxyPort), this.proxyAuth, this.proxyUser, this.proxyPassword, this.proxyDomain));
        this.sender.setClientHeaderValue(CLIENT_NAME);
        this.sender.setRetryableHttpCodeRegex(this.retryableHttpCodeRegex);
        this.sender.init();
        if (this.flusher != null) {
            this.flusher.stop();
        }
        this.flusher = new SumoBufferFlusher(this.flushingAccuracyMs, this.messagesPerRequest, this.maxFlushIntervalMs, this.sender, this.queue, this.flushAllBeforeStopping);
        this.flusher.start();
    }

    protected void append(ILoggingEvent event) {
        try {
            this.queue.add((Object)this.convertToString(event));
        }
        catch (Exception e) {
            this.logger.error("Unable to insert log entry into log queue.", (Throwable)e);
        }
    }

    public void stop() {
        super.stop();
        this.logger.debug("Closing SumoLogicAppender: " + this.getName());
        try {
            if (this.flusher != null) {
                this.flusher.stop();
                this.flusher = null;
            }
            if (this.sender != null) {
                this.sender.close();
                this.sender = null;
            }
        }
        catch (IOException e) {
            this.logger.error("Unable to close appender", (Throwable)e);
        }
    }

    private String convertToString(ILoggingEvent event) {
        if (this.encoder.getCharset() == null) {
            return this.encoder.getLayout().doLayout((Object)event);
        }
        return new String(this.encoder.encode((Object)event), this.encoder.getCharset());
    }
}

