/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.commons.modeler.mbeans;

import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import com.sun.org.apache.commons.modeler.Registry;
import com.sun.org.apache.commons.modeler.mbeans.MBeanProxy;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class SimpleRemoteConnector {
    private static Log log = LogFactory.getLog(SimpleRemoteConnector.class);
    String webServerHost = "localhost";
    int webServerPort = 8080;
    String statusPath = "/jkstatus";
    String user;
    String pass;
    String domain;
    String localDomain;
    String filter;
    long lastRefresh = 0L;
    long updateInterval = 5000L;
    String prefix = "";
    Registry reg;
    MBeanServer mserver;
    HashMap mbeans = new HashMap();

    public String getWebServerHost() {
        return this.webServerHost;
    }

    public void setWebServerHost(String webServerHost) {
        this.webServerHost = webServerHost;
    }

    public int getWebServerPort() {
        return this.webServerPort;
    }

    public void setWebServerPort(int webServerPort) {
        this.webServerPort = webServerPort;
    }

    public long getUpdateInterval() {
        return this.updateInterval;
    }

    public void setUpdateInterval(long updateInterval) {
        this.updateInterval = updateInterval;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPass() {
        return this.pass;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public String getStatusPath() {
        return this.statusPath;
    }

    public void setStatusPath(String statusPath) {
        this.statusPath = statusPath;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void destroy() {
        try {
            for (MBeanProxy proxy : this.mbeans.values()) {
                ObjectName oname = proxy.getJmxName();
                Registry.getRegistry().getMBeanServer().unregisterMBean(oname);
            }
        }
        catch (Throwable t) {
            log.error((Object)"Destroy error", t);
        }
    }

    public void init() throws IOException {
        try {
            log.info((Object)("init " + this.webServerHost + " " + this.webServerPort));
            this.reg = Registry.getRegistry();
            this.refreshAttributes();
        }
        catch (Throwable t) {
            log.error((Object)"Init error", t);
        }
    }

    public void start() throws IOException {
        System.out.println("XXX start");
        if (this.reg == null) {
            this.init();
        }
    }

    public void refresh() {
        long time = System.currentTimeMillis();
        if (time - this.lastRefresh < this.updateInterval) {
            return;
        }
        System.out.println("refresh... ");
        this.lastRefresh = time;
        this.refreshAttributes();
    }

    public void refreshAttributes() {
        try {
            InputStream is;
            int cnt = 0;
            if (this.filter == null) {
                this.filter = this.domain + ":*";
            }
            if ((is = this.getStream("qry=" + this.filter)) == null) {
                return;
            }
            Manifest mf = new Manifest(is);
            HashMap<ObjectName, String> currentObjects = new HashMap<ObjectName, String>();
            Map<String, Attributes> entries = mf.getEntries();
            for (String name : entries.keySet()) {
                Attributes attrs = entries.get(name);
                ObjectName oname = new ObjectName(name);
                currentObjects.put(oname, "");
                MBeanProxy proxy = (MBeanProxy)this.mbeans.get(oname);
                if (proxy == null) {
                    log.debug((Object)("New object " + name));
                    String code = attrs.getValue("modelerType");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Register " + name + " " + code));
                    }
                    proxy = new MBeanProxy(this, code);
                    this.mbeans.put(oname, proxy);
                    MBeanServer mserver = Registry.getRegistry().getMBeanServer();
                    if (!mserver.isRegistered(oname)) {
                        mserver.registerMBean(proxy, oname);
                    }
                }
                for (Object o : attrs.keySet()) {
                    String att;
                    String string = att = o == null ? null : o.toString();
                    if ("modelerType".equals(att)) continue;
                    String val = attrs.getValue(att);
                    proxy.update(att, val);
                    ++cnt;
                }
            }
            for (ObjectName on : this.mbeans.keySet()) {
                if (currentObjects.get(on) != null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No longer alive " + on));
                }
                try {
                    this.mserver.unregisterMBean(on);
                }
                catch (Throwable t) {
                    log.info((Object)("Error unregistering " + on + " " + t.toString()));
                }
            }
            log.info((Object)("Refreshing attributes " + cnt));
        }
        catch (Exception ex) {
            log.info((Object)"Error ", (Throwable)ex);
        }
    }

    public void refreshMetadata() {
        try {
            int cnt = 0;
            int newCnt = 0;
            InputStream is = this.getStream("getMetadata=" + this.domain + ":*");
            if (is == null) {
                return;
            }
            log.info((Object)("Refreshing metadata " + cnt + " " + newCnt));
        }
        catch (Exception ex) {
            log.info((Object)"Error ", (Throwable)ex);
        }
    }

    public Object invoke(Object oname, String name, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        try {
            InputStream is = this.getStream("invoke=" + name + "&name=" + oname.toString());
            if (is == null) {
                return null;
            }
            this.refreshAttributes();
        }
        catch (Exception ex) {
            throw new MBeanException(ex);
        }
        return null;
    }

    public void setAttribute(ObjectName oname, Attribute attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            String val = (String)attribute.getValue();
            String name = attribute.getName();
            InputStream is = this.getStream("set=" + name + "&name=" + oname.toString() + "&value=" + val);
            if (is == null) {
                return;
            }
            this.refreshAttributes();
        }
        catch (Exception ex) {
            throw new MBeanException(ex);
        }
    }

    protected InputStream getStream(String qry) throws Exception {
        try {
            String path = this.statusPath + "?" + qry;
            URL url = new URL("http", this.webServerHost, this.webServerPort, path);
            log.debug((Object)("Connecting to " + url));
            URLConnection urlc = url.openConnection();
            InputStream is = urlc.getInputStream();
            return is;
        }
        catch (IOException e) {
            log.info((Object)("Can't connect to jkstatus " + this.webServerHost + ":" + this.webServerPort + " " + e.toString()));
            return null;
        }
    }
}

