/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.apt;

import com.sun.enterprise.tools.apt.InhabitantsDescriptor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

final class DescriptorList {
    final Map<String, InhabitantsDescriptor> descriptors = new HashMap<String, InhabitantsDescriptor>();
    private boolean loaded;

    DescriptorList() {
    }

    protected void loadExisting(AnnotationProcessorEnvironment env) {
        File outDir;
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        String outDirectory = (String)env.getOptions().get("-d");
        if (outDirectory == null) {
            outDirectory = System.getProperty("user.dir");
        }
        if (!(outDir = new File(new File(outDirectory), "META-INF/inhabitants").getAbsoluteFile()).exists()) {
            return;
        }
        for (File file : outDir.listFiles()) {
            if (file.isDirectory()) continue;
            try {
                this.descriptors.put(file.getName(), new InhabitantsDescriptor(file));
            }
            catch (IOException e) {
                env.getMessager().printError(e.getMessage());
            }
        }
    }

    public void write(AnnotationProcessorEnvironment env) {
        String outDirectory = (String)env.getOptions().get("-d");
        if (outDirectory == null) {
            outDirectory = (String)env.getOptions().get("-s");
        }
        if (outDirectory == null) {
            outDirectory = System.getProperty("user.home");
        }
        for (Map.Entry<String, InhabitantsDescriptor> e : this.descriptors.entrySet()) {
            e.getValue().write(new File(outDirectory), env, e.getKey());
        }
    }

    public InhabitantsDescriptor get(String name) {
        InhabitantsDescriptor descriptor = this.descriptors.get(name);
        if (descriptor == null) {
            descriptor = new InhabitantsDescriptor();
            this.descriptors.put(name, descriptor);
        }
        return descriptor;
    }
}

