/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.apt;

import com.sun.enterprise.tools.apt.TypeHierarchyVisitor;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.AnnotationType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.TypeMirror;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.jvnet.hk2.annotations.InhabitantMetadata;

public class InhabitantMetadataProcessor
extends TypeHierarchyVisitor<Map<String, String>> {
    private final Map<AnnotationType, Model> models = new HashMap<AnnotationType, Model>();

    public Map<String, String> process(TypeDeclaration d) {
        this.visited.clear();
        HashMap<String, String> r = new HashMap<String, String>();
        this.check(d, (Map<String, String>)r);
        return r;
    }

    @Override
    protected void check(TypeDeclaration d, Map<String, String> result) {
        this.checkAnnotations(d, result);
        super.check(d, result);
    }

    private void checkAnnotations(TypeDeclaration d, Map<String, String> result) {
        for (AnnotationMirror a : d.getAnnotationMirrors()) {
            this.getModel(a.getAnnotationType()).parse(a, result);
            for (AnnotationMirror b : a.getAnnotationType().getDeclaration().getAnnotationMirrors()) {
                this.getModel(b.getAnnotationType()).parse(b, result);
            }
        }
    }

    private boolean hasMetaAnnotation(AnnotationMirror a, Class<? extends Annotation> type) {
        return a.getAnnotationType().getDeclaration().getAnnotation(type) != null;
    }

    private Model getModel(AnnotationType type) {
        Model model = this.models.get(type);
        if (model == null) {
            model = new Model(type);
            this.models.put(type, model);
        }
        return model;
    }

    private static final class Model {
        private final AnnotationType type;
        private final Map<AnnotationTypeElementDeclaration, String> metadataProperties = new HashMap<AnnotationTypeElementDeclaration, String>();

        public Model(AnnotationType type) {
            this.type = type;
            for (AnnotationTypeElementDeclaration e : type.getDeclaration().getMethods()) {
                InhabitantMetadata im = (InhabitantMetadata)e.getAnnotation(InhabitantMetadata.class);
                if (im == null) continue;
                String name = im.value();
                if (name.length() == 0) {
                    name = type.getDeclaration().getQualifiedName() + '.' + e.getSimpleName();
                }
                this.metadataProperties.put(e, name);
            }
        }

        public void parse(AnnotationMirror a, Map<String, String> metadataBag) {
            assert (a.getAnnotationType().equals(this.type));
            for (Map.Entry<AnnotationTypeElementDeclaration, String> e : this.metadataProperties.entrySet()) {
                AnnotationValue value = (AnnotationValue)a.getElementValues().get(e.getKey());
                if (value == null) continue;
                metadataBag.put(e.getValue(), this.toString(value));
            }
        }

        private String toString(AnnotationValue value) {
            TypeMirror tm;
            if (value.getValue() instanceof TypeMirror && (tm = (TypeMirror)value.getValue()) instanceof DeclaredType) {
                DeclaredType dt = (DeclaredType)tm;
                return this.getClassName(dt.getDeclaration());
            }
            return value.toString();
        }

        private String getClassName(TypeDeclaration d) {
            if (d.getDeclaringType() != null) {
                return this.getClassName(d.getDeclaringType()) + '$' + d.getSimpleName();
            }
            return d.getQualifiedName();
        }
    }
}

